/* ***************************************************************************************
* FILE:          CombinedTextMeasureContext.h
* SW-COMPONENT:  HMI-BASE
* DESCRIPTION:  CombinedTextMeasureContext is part of HMI-Base Widget Library
* COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(CombinedTextMeasureContext_h)
#define CombinedTextMeasureContext_h

#include <Candera/TextEngine/TextMeasureContext.h>
#include <Candera/TextEngine/TextRect.h>
#include <Candera/TextEngine/Style.h>

using namespace Candera::TextRendering;

namespace HmiBase {
namespace TextRendering {


/** @addtogroup CanderaTextEngine
 *  @{
 */

/**
 *  @brief CombinedTextMeasureContext is used to measure the movement of the
 *  text cursor in x direction and glyph bitmaps extents in y direction.
 *
 *  This class builds the smallest axis aligned rectangle that contains width and height as follows:
 *  width = width of the whole surface swept by the cursor when moving while processing the text.
 *  The cursor is considered to be a segment of length equal to the style
 *  height.
 *  height =  minimum surface height where we can reder all the glyph bitmaps that are measured by it
 *
 *  This class is best used when we need to layout text thereby spaces are not ignored and also to determine the exact height value required to render the glyph bitmaps
 */
class CombinedTextMeasureContext : public TextMeasureContext
{
   public:
      /**
       * Constructor.
       * @param style Style from which font metrics are retrieved.
       * @param referenceContext Context to retrieve caching strategy from.
       */
      CombinedTextMeasureContext(const TextRenderContext* referenceContext = 0);

      /**
       * Retrieve the rectangle computed by the context.
       * The rectangle is equal to TextRect() if nothing was measured.
       * @return The computed rectangle.
       */
      const TextRect& GetTextRectangle() const;

      /**
       * Retrieve the text direction of the last measured glyph.
       * @return The text direction.
       */
      GlyphBitmap::Direction GetLastDirection() const
      {
         return m_lastDirection;
      }
   private:
      // Overrides function from TextMeasureContext.
      virtual void Measure(PixelPosition x, PixelPosition y, const GlyphBitmap& glyph) ;

      TextRect m_textRectangle;
      GlyphBitmap::Direction m_lastDirection;
};


/** @} */ // end of CanderaTextEngine
}// namespace TextRendering
}// namespace HmiBase

#endif// CombinedTextMeasureContext_h
