/* ***************************************************************************************
* FILE:          CombinedTextMeasureContext.cpp
* SW-COMPONENT:  HMI-BASE
* DESCRIPTION:  CombinedTextMeasureContext is part of HMI-Base Widget Library
* COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "CombinedTextMeasureContext.h"
#include <Candera/TextEngine/Style.h>

namespace HmiBase {
namespace TextRendering {

CombinedTextMeasureContext::CombinedTextMeasureContext(const TextRenderContext* referenceContext) :
   TextMeasureContext(referenceContext),
   m_textRectangle(TextRect::GetMin()),
   m_lastDirection(GlyphBitmap::Implicit)
{
}


void CombinedTextMeasureContext::Measure(PixelPosition x, PixelPosition y, const GlyphBitmap& glyph)
{
   // compute bounds
   PixelPosition left = static_cast<PixelPosition>(x - glyph.left);
   PixelPosition right = static_cast<PixelPosition>(left + glyph.xadvance);

   PixelPosition top = y;
   PixelPosition bottom = static_cast<PixelPosition>((y + static_cast<PixelPosition>(glyph.height)) - 1);

   m_textRectangle = m_textRectangle.Union(
                        TextRect(left, top, right, bottom));
   m_lastDirection = glyph.direction;
}


const TextRect& CombinedTextMeasureContext::GetTextRectangle() const
{
   return m_textRectangle.IsNegative() ? TextRect::GetDefault() : m_textRectangle;
}


}    // namespace TextRendering
}    // namespace HmiBase
