/* ***************************************************************************************
* FILE:          RtStringInStream.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtStringInStream is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once
#include <Widgets/2D/RichText/Utils/RtTextInStream.h>
#include <FeatStd/Util/TextEncoding.h>

namespace hmibase {
namespace widget {
namespace richtext {

class StringInStream : public TextInStream
{
   public:
      StringInStream(FeatStd::String string);

      virtual FeatStd::UInt32 GetAvailableCharCount() const override;
      virtual FeatStd::UInt32 GetTextLength() const override;
      virtual bool IsEndOfStreamReached() const override;
      virtual FeatStd::UInt32 PeekChar() const override;
      virtual FeatStd::String PeekString(FeatStd::UInt32 count) const override;
      virtual FeatStd::UInt32 ReadChar() override;
      virtual FeatStd::String ReadCompleteText() override;
      virtual FeatStd::String ReadString(FeatStd::UInt32 count) override;
      virtual void Reset() override;

   private:
      FeatStd::String m_string;
      FeatStd::Internal::Utf8TextIterator m_it;
      const FeatStd::TChar* m_pos;
      FeatStd::SizeType m_availableCharCount;

      FeatStd::UInt32 GetTextLengthImpl() const;
};


inline
FeatStd::UInt32 StringInStream::GetAvailableCharCount() const
{
   return m_availableCharCount;
}


inline
FeatStd::UInt32 StringInStream::GetTextLength() const
{
   return GetTextLengthImpl();
}


inline
bool StringInStream::IsEndOfStreamReached() const
{
   return PeekChar() == L'\0';
}


inline
FeatStd::UInt32 StringInStream::PeekChar() const
{
   return *m_it;
}


inline
FeatStd::UInt32 StringInStream::GetTextLengthImpl() const
{
   return m_string.GetCodePointCount();
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
