/* ***************************************************************************************
* FILE:          RtCaseFolding.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtCaseFolding is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "RtCaseFolding.h"
#include <FeatStd/Util/BinarySearch.h>

namespace hmibase {
namespace widget {
namespace richtext {

// see https://www.unicode.org/Public/UCD/latest/ucd/CaseFolding.txt

const CaseFolding::Mapping CaseFolding::mapping[] =
{
   //<code>; <status>; <mapping>; # <name>
   { 0x0041, /* C, */ 0x0061 }, // # LATIN CAPITAL LETTER A
   { 0x0042, /* C, */ 0x0062 }, // # LATIN CAPITAL LETTER B
   { 0x0043, /* C, */ 0x0063 }, // # LATIN CAPITAL LETTER C
   { 0x0044, /* C, */ 0x0064 }, // # LATIN CAPITAL LETTER D
   { 0x0045, /* C, */ 0x0065 }, // # LATIN CAPITAL LETTER E
   { 0x0046, /* C, */ 0x0066 }, // # LATIN CAPITAL LETTER F
   { 0x0047, /* C, */ 0x0067 }, // # LATIN CAPITAL LETTER G
   { 0x0048, /* C, */ 0x0068 }, // # LATIN CAPITAL LETTER H
   { 0x0049, /* C, */ 0x0069 }, // # LATIN CAPITAL LETTER I
   { 0x004A, /* C, */ 0x006A }, // # LATIN CAPITAL LETTER J
   { 0x004B, /* C, */ 0x006B }, // # LATIN CAPITAL LETTER K
   { 0x004C, /* C, */ 0x006C }, // # LATIN CAPITAL LETTER L
   { 0x004D, /* C, */ 0x006D }, // # LATIN CAPITAL LETTER M
   { 0x004E, /* C, */ 0x006E }, // # LATIN CAPITAL LETTER N
   { 0x004F, /* C, */ 0x006F }, // # LATIN CAPITAL LETTER O
   { 0x0050, /* C, */ 0x0070 }, // # LATIN CAPITAL LETTER P
   { 0x0051, /* C, */ 0x0071 }, // # LATIN CAPITAL LETTER Q
   { 0x0052, /* C, */ 0x0072 }, // # LATIN CAPITAL LETTER R
   { 0x0053, /* C, */ 0x0073 }, // # LATIN CAPITAL LETTER S
   { 0x0054, /* C, */ 0x0074 }, // # LATIN CAPITAL LETTER T
   { 0x0055, /* C, */ 0x0075 }, // # LATIN CAPITAL LETTER U
   { 0x0056, /* C, */ 0x0076 }, // # LATIN CAPITAL LETTER V
   { 0x0057, /* C, */ 0x0077 }, // # LATIN CAPITAL LETTER W
   { 0x0058, /* C, */ 0x0078 }, // # LATIN CAPITAL LETTER X
   { 0x0059, /* C, */ 0x0079 }, // # LATIN CAPITAL LETTER Y
   { 0x005A, /* C, */ 0x007A }, // # LATIN CAPITAL LETTER Z
   { 0x00B5, /* C, */ 0x03BC }, // # MICRO SIGN
   { 0x00C0, /* C, */ 0x00E0 }, // # LATIN CAPITAL LETTER A WITH GRAVE
   { 0x00C1, /* C, */ 0x00E1 }, // # LATIN CAPITAL LETTER A WITH ACUTE
   { 0x00C2, /* C, */ 0x00E2 }, // # LATIN CAPITAL LETTER A WITH CIRCUMFLEX
   { 0x00C3, /* C, */ 0x00E3 }, // # LATIN CAPITAL LETTER A WITH TILDE
   { 0x00C4, /* C, */ 0x00E4 }, // # LATIN CAPITAL LETTER A WITH DIAERESIS
   { 0x00C5, /* C, */ 0x00E5 }, // # LATIN CAPITAL LETTER A WITH RING ABOVE
   { 0x00C6, /* C, */ 0x00E6 }, // # LATIN CAPITAL LETTER AE
   { 0x00C7, /* C, */ 0x00E7 }, // # LATIN CAPITAL LETTER C WITH CEDILLA
   { 0x00C8, /* C, */ 0x00E8 }, // # LATIN CAPITAL LETTER E WITH GRAVE
   { 0x00C9, /* C, */ 0x00E9 }, // # LATIN CAPITAL LETTER E WITH ACUTE
   { 0x00CA, /* C, */ 0x00EA }, // # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
   { 0x00CB, /* C, */ 0x00EB }, // # LATIN CAPITAL LETTER E WITH DIAERESIS
   { 0x00CC, /* C, */ 0x00EC }, // # LATIN CAPITAL LETTER I WITH GRAVE
   { 0x00CD, /* C, */ 0x00ED }, // # LATIN CAPITAL LETTER I WITH ACUTE
   { 0x00CE, /* C, */ 0x00EE }, // # LATIN CAPITAL LETTER I WITH CIRCUMFLEX
   { 0x00CF, /* C, */ 0x00EF }, // # LATIN CAPITAL LETTER I WITH DIAERESIS
   { 0x00D0, /* C, */ 0x00F0 }, // # LATIN CAPITAL LETTER ETH
   { 0x00D1, /* C, */ 0x00F1 }, // # LATIN CAPITAL LETTER N WITH TILDE
   { 0x00D2, /* C, */ 0x00F2 }, // # LATIN CAPITAL LETTER O WITH GRAVE
   { 0x00D3, /* C, */ 0x00F3 }, // # LATIN CAPITAL LETTER O WITH ACUTE
   { 0x00D4, /* C, */ 0x00F4 }, // # LATIN CAPITAL LETTER O WITH CIRCUMFLEX
   { 0x00D5, /* C, */ 0x00F5 }, // # LATIN CAPITAL LETTER O WITH TILDE
   { 0x00D6, /* C, */ 0x00F6 }, // # LATIN CAPITAL LETTER O WITH DIAERESIS
   { 0x00D8, /* C, */ 0x00F8 }, // # LATIN CAPITAL LETTER O WITH STROKE
   { 0x00D9, /* C, */ 0x00F9 }, // # LATIN CAPITAL LETTER U WITH GRAVE
   { 0x00DA, /* C, */ 0x00FA }, // # LATIN CAPITAL LETTER U WITH ACUTE
   { 0x00DB, /* C, */ 0x00FB }, // # LATIN CAPITAL LETTER U WITH CIRCUMFLEX
   { 0x00DC, /* C, */ 0x00FC }, // # LATIN CAPITAL LETTER U WITH DIAERESIS
   { 0x00DD, /* C, */ 0x00FD }, // # LATIN CAPITAL LETTER Y WITH ACUTE
   { 0x00DE, /* C, */ 0x00FE }, // # LATIN CAPITAL LETTER THORN
   { 0x0100, /* C, */ 0x0101 }, // # LATIN CAPITAL LETTER A WITH MACRON
   { 0x0102, /* C, */ 0x0103 }, // # LATIN CAPITAL LETTER A WITH BREVE
   { 0x0104, /* C, */ 0x0105 }, // # LATIN CAPITAL LETTER A WITH OGONEK
   { 0x0106, /* C, */ 0x0107 }, // # LATIN CAPITAL LETTER C WITH ACUTE
   { 0x0108, /* C, */ 0x0109 }, // # LATIN CAPITAL LETTER C WITH CIRCUMFLEX
   { 0x010A, /* C, */ 0x010B }, // # LATIN CAPITAL LETTER C WITH DOT ABOVE
   { 0x010C, /* C, */ 0x010D }, // # LATIN CAPITAL LETTER C WITH CARON
   { 0x010E, /* C, */ 0x010F }, // # LATIN CAPITAL LETTER D WITH CARON
   { 0x0110, /* C, */ 0x0111 }, // # LATIN CAPITAL LETTER D WITH STROKE
   { 0x0112, /* C, */ 0x0113 }, // # LATIN CAPITAL LETTER E WITH MACRON
   { 0x0114, /* C, */ 0x0115 }, // # LATIN CAPITAL LETTER E WITH BREVE
   { 0x0116, /* C, */ 0x0117 }, // # LATIN CAPITAL LETTER E WITH DOT ABOVE
   { 0x0118, /* C, */ 0x0119 }, // # LATIN CAPITAL LETTER E WITH OGONEK
   { 0x011A, /* C, */ 0x011B }, // # LATIN CAPITAL LETTER E WITH CARON
   { 0x011C, /* C, */ 0x011D }, // # LATIN CAPITAL LETTER G WITH CIRCUMFLEX
   { 0x011E, /* C, */ 0x011F }, // # LATIN CAPITAL LETTER G WITH BREVE
   { 0x0120, /* C, */ 0x0121 }, // # LATIN CAPITAL LETTER G WITH DOT ABOVE
   { 0x0122, /* C, */ 0x0123 }, // # LATIN CAPITAL LETTER G WITH CEDILLA
   { 0x0124, /* C, */ 0x0125 }, // # LATIN CAPITAL LETTER H WITH CIRCUMFLEX
   { 0x0126, /* C, */ 0x0127 }, // # LATIN CAPITAL LETTER H WITH STROKE
   { 0x0128, /* C, */ 0x0129 }, // # LATIN CAPITAL LETTER I WITH TILDE
   { 0x012A, /* C, */ 0x012B }, // # LATIN CAPITAL LETTER I WITH MACRON
   { 0x012C, /* C, */ 0x012D }, // # LATIN CAPITAL LETTER I WITH BREVE
   { 0x012E, /* C, */ 0x012F }, // # LATIN CAPITAL LETTER I WITH OGONEK
   { 0x0132, /* C, */ 0x0133 }, // # LATIN CAPITAL LIGATURE IJ
   { 0x0134, /* C, */ 0x0135 }, // # LATIN CAPITAL LETTER J WITH CIRCUMFLEX
   { 0x0136, /* C, */ 0x0137 }, // # LATIN CAPITAL LETTER K WITH CEDILLA
   { 0x0139, /* C, */ 0x013A }, // # LATIN CAPITAL LETTER L WITH ACUTE
   { 0x013B, /* C, */ 0x013C }, // # LATIN CAPITAL LETTER L WITH CEDILLA
   { 0x013D, /* C, */ 0x013E }, // # LATIN CAPITAL LETTER L WITH CARON
   { 0x013F, /* C, */ 0x0140 }, // # LATIN CAPITAL LETTER L WITH MIDDLE DOT
   { 0x0141, /* C, */ 0x0142 }, // # LATIN CAPITAL LETTER L WITH STROKE
   { 0x0143, /* C, */ 0x0144 }, // # LATIN CAPITAL LETTER N WITH ACUTE
   { 0x0145, /* C, */ 0x0146 }, // # LATIN CAPITAL LETTER N WITH CEDILLA
   { 0x0147, /* C, */ 0x0148 }, // # LATIN CAPITAL LETTER N WITH CARON
   { 0x014A, /* C, */ 0x014B }, // # LATIN CAPITAL LETTER ENG
   { 0x014C, /* C, */ 0x014D }, // # LATIN CAPITAL LETTER O WITH MACRON
   { 0x014E, /* C, */ 0x014F }, // # LATIN CAPITAL LETTER O WITH BREVE
   { 0x0150, /* C, */ 0x0151 }, // # LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
   { 0x0152, /* C, */ 0x0153 }, // # LATIN CAPITAL LIGATURE OE
   { 0x0154, /* C, */ 0x0155 }, // # LATIN CAPITAL LETTER R WITH ACUTE
   { 0x0156, /* C, */ 0x0157 }, // # LATIN CAPITAL LETTER R WITH CEDILLA
   { 0x0158, /* C, */ 0x0159 }, // # LATIN CAPITAL LETTER R WITH CARON
   { 0x015A, /* C, */ 0x015B }, // # LATIN CAPITAL LETTER S WITH ACUTE
   { 0x015C, /* C, */ 0x015D }, // # LATIN CAPITAL LETTER S WITH CIRCUMFLEX
   { 0x015E, /* C, */ 0x015F }, // # LATIN CAPITAL LETTER S WITH CEDILLA
   { 0x0160, /* C, */ 0x0161 }, // # LATIN CAPITAL LETTER S WITH CARON
   { 0x0162, /* C, */ 0x0163 }, // # LATIN CAPITAL LETTER T WITH CEDILLA
   { 0x0164, /* C, */ 0x0165 }, // # LATIN CAPITAL LETTER T WITH CARON
   { 0x0166, /* C, */ 0x0167 }, // # LATIN CAPITAL LETTER T WITH STROKE
   { 0x0168, /* C, */ 0x0169 }, // # LATIN CAPITAL LETTER U WITH TILDE
   { 0x016A, /* C, */ 0x016B }, // # LATIN CAPITAL LETTER U WITH MACRON
   { 0x016C, /* C, */ 0x016D }, // # LATIN CAPITAL LETTER U WITH BREVE
   { 0x016E, /* C, */ 0x016F }, // # LATIN CAPITAL LETTER U WITH RING ABOVE
   { 0x0170, /* C, */ 0x0171 }, // # LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
   { 0x0172, /* C, */ 0x0173 }, // # LATIN CAPITAL LETTER U WITH OGONEK
   { 0x0174, /* C, */ 0x0175 }, // # LATIN CAPITAL LETTER W WITH CIRCUMFLEX
   { 0x0176, /* C, */ 0x0177 }, // # LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
   { 0x0178, /* C, */ 0x00FF }, // # LATIN CAPITAL LETTER Y WITH DIAERESIS
   { 0x0179, /* C, */ 0x017A }, // # LATIN CAPITAL LETTER Z WITH ACUTE
   { 0x017B, /* C, */ 0x017C }, // # LATIN CAPITAL LETTER Z WITH DOT ABOVE
   { 0x017D, /* C, */ 0x017E }, // # LATIN CAPITAL LETTER Z WITH CARON
   { 0x017F, /* C, */ 0x0073 }, // # LATIN SMALL LETTER LONG S
   { 0x0181, /* C, */ 0x0253 }, // # LATIN CAPITAL LETTER B WITH HOOK
   { 0x0182, /* C, */ 0x0183 }, // # LATIN CAPITAL LETTER B WITH TOPBAR
   { 0x0184, /* C, */ 0x0185 }, // # LATIN CAPITAL LETTER TONE SIX
   { 0x0186, /* C, */ 0x0254 }, // # LATIN CAPITAL LETTER OPEN O
   { 0x0187, /* C, */ 0x0188 }, // # LATIN CAPITAL LETTER C WITH HOOK
   { 0x0189, /* C, */ 0x0256 }, // # LATIN CAPITAL LETTER AFRICAN D
   { 0x018A, /* C, */ 0x0257 }, // # LATIN CAPITAL LETTER D WITH HOOK
   { 0x018B, /* C, */ 0x018C }, // # LATIN CAPITAL LETTER D WITH TOPBAR
   { 0x018E, /* C, */ 0x01DD }, // # LATIN CAPITAL LETTER REVERSED E
   { 0x018F, /* C, */ 0x0259 }, // # LATIN CAPITAL LETTER SCHWA
   { 0x0190, /* C, */ 0x025B }, // # LATIN CAPITAL LETTER OPEN E
   { 0x0191, /* C, */ 0x0192 }, // # LATIN CAPITAL LETTER F WITH HOOK
   { 0x0193, /* C, */ 0x0260 }, // # LATIN CAPITAL LETTER G WITH HOOK
   { 0x0194, /* C, */ 0x0263 }, // # LATIN CAPITAL LETTER GAMMA
   { 0x0196, /* C, */ 0x0269 }, // # LATIN CAPITAL LETTER IOTA
   { 0x0197, /* C, */ 0x0268 }, // # LATIN CAPITAL LETTER I WITH STROKE
   { 0x0198, /* C, */ 0x0199 }, // # LATIN CAPITAL LETTER K WITH HOOK
   { 0x019C, /* C, */ 0x026F }, // # LATIN CAPITAL LETTER TURNED M
   { 0x019D, /* C, */ 0x0272 }, // # LATIN CAPITAL LETTER N WITH LEFT HOOK
   { 0x019F, /* C, */ 0x0275 }, // # LATIN CAPITAL LETTER O WITH MIDDLE TILDE
   { 0x01A0, /* C, */ 0x01A1 }, // # LATIN CAPITAL LETTER O WITH HORN
   { 0x01A2, /* C, */ 0x01A3 }, // # LATIN CAPITAL LETTER OI
   { 0x01A4, /* C, */ 0x01A5 }, // # LATIN CAPITAL LETTER P WITH HOOK
   { 0x01A6, /* C, */ 0x0280 }, // # LATIN LETTER YR
   { 0x01A7, /* C, */ 0x01A8 }, // # LATIN CAPITAL LETTER TONE TWO
   { 0x01A9, /* C, */ 0x0283 }, // # LATIN CAPITAL LETTER ESH
   { 0x01AC, /* C, */ 0x01AD }, // # LATIN CAPITAL LETTER T WITH HOOK
   { 0x01AE, /* C, */ 0x0288 }, // # LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
   { 0x01AF, /* C, */ 0x01B0 }, // # LATIN CAPITAL LETTER U WITH HORN
   { 0x01B1, /* C, */ 0x028A }, // # LATIN CAPITAL LETTER UPSILON
   { 0x01B2, /* C, */ 0x028B }, // # LATIN CAPITAL LETTER V WITH HOOK
   { 0x01B3, /* C, */ 0x01B4 }, // # LATIN CAPITAL LETTER Y WITH HOOK
   { 0x01B5, /* C, */ 0x01B6 }, // # LATIN CAPITAL LETTER Z WITH STROKE
   { 0x01B7, /* C, */ 0x0292 }, // # LATIN CAPITAL LETTER EZH
   { 0x01B8, /* C, */ 0x01B9 }, // # LATIN CAPITAL LETTER EZH REVERSED
   { 0x01BC, /* C, */ 0x01BD }, // # LATIN CAPITAL LETTER TONE FIVE
   { 0x01C4, /* C, */ 0x01C6 }, // # LATIN CAPITAL LETTER DZ WITH CARON
   { 0x01C5, /* C, */ 0x01C6 }, // # LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
   { 0x01C7, /* C, */ 0x01C9 }, // # LATIN CAPITAL LETTER LJ
   { 0x01C8, /* C, */ 0x01C9 }, // # LATIN CAPITAL LETTER L WITH SMALL LETTER J
   { 0x01CA, /* C, */ 0x01CC }, // # LATIN CAPITAL LETTER NJ
   { 0x01CB, /* C, */ 0x01CC }, // # LATIN CAPITAL LETTER N WITH SMALL LETTER J
   { 0x01CD, /* C, */ 0x01CE }, // # LATIN CAPITAL LETTER A WITH CARON
   { 0x01CF, /* C, */ 0x01D0 }, // # LATIN CAPITAL LETTER I WITH CARON
   { 0x01D1, /* C, */ 0x01D2 }, // # LATIN CAPITAL LETTER O WITH CARON
   { 0x01D3, /* C, */ 0x01D4 }, // # LATIN CAPITAL LETTER U WITH CARON
   { 0x01D5, /* C, */ 0x01D6 }, // # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
   { 0x01D7, /* C, */ 0x01D8 }, // # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
   { 0x01D9, /* C, */ 0x01DA }, // # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
   { 0x01DB, /* C, */ 0x01DC }, // # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
   { 0x01DE, /* C, */ 0x01DF }, // # LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
   { 0x01E0, /* C, */ 0x01E1 }, // # LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
   { 0x01E2, /* C, */ 0x01E3 }, // # LATIN CAPITAL LETTER AE WITH MACRON
   { 0x01E4, /* C, */ 0x01E5 }, // # LATIN CAPITAL LETTER G WITH STROKE
   { 0x01E6, /* C, */ 0x01E7 }, // # LATIN CAPITAL LETTER G WITH CARON
   { 0x01E8, /* C, */ 0x01E9 }, // # LATIN CAPITAL LETTER K WITH CARON
   { 0x01EA, /* C, */ 0x01EB }, // # LATIN CAPITAL LETTER O WITH OGONEK
   { 0x01EC, /* C, */ 0x01ED }, // # LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
   { 0x01EE, /* C, */ 0x01EF }, // # LATIN CAPITAL LETTER EZH WITH CARON
   { 0x01F1, /* C, */ 0x01F3 }, // # LATIN CAPITAL LETTER DZ
   { 0x01F2, /* C, */ 0x01F3 }, // # LATIN CAPITAL LETTER D WITH SMALL LETTER Z
   { 0x01F4, /* C, */ 0x01F5 }, // # LATIN CAPITAL LETTER G WITH ACUTE
   { 0x01F6, /* C, */ 0x0195 }, // # LATIN CAPITAL LETTER HWAIR
   { 0x01F7, /* C, */ 0x01BF }, // # LATIN CAPITAL LETTER WYNN
   { 0x01F8, /* C, */ 0x01F9 }, // # LATIN CAPITAL LETTER N WITH GRAVE
   { 0x01FA, /* C, */ 0x01FB }, // # LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
   { 0x01FC, /* C, */ 0x01FD }, // # LATIN CAPITAL LETTER AE WITH ACUTE
   { 0x01FE, /* C, */ 0x01FF }, // # LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
   { 0x0200, /* C, */ 0x0201 }, // # LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
   { 0x0202, /* C, */ 0x0203 }, // # LATIN CAPITAL LETTER A WITH INVERTED BREVE
   { 0x0204, /* C, */ 0x0205 }, // # LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
   { 0x0206, /* C, */ 0x0207 }, // # LATIN CAPITAL LETTER E WITH INVERTED BREVE
   { 0x0208, /* C, */ 0x0209 }, // # LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
   { 0x020A, /* C, */ 0x020B }, // # LATIN CAPITAL LETTER I WITH INVERTED BREVE
   { 0x020C, /* C, */ 0x020D }, // # LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
   { 0x020E, /* C, */ 0x020F }, // # LATIN CAPITAL LETTER O WITH INVERTED BREVE
   { 0x0210, /* C, */ 0x0211 }, // # LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
   { 0x0212, /* C, */ 0x0213 }, // # LATIN CAPITAL LETTER R WITH INVERTED BREVE
   { 0x0214, /* C, */ 0x0215 }, // # LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
   { 0x0216, /* C, */ 0x0217 }, // # LATIN CAPITAL LETTER U WITH INVERTED BREVE
   { 0x0218, /* C, */ 0x0219 }, // # LATIN CAPITAL LETTER S WITH COMMA BELOW
   { 0x021A, /* C, */ 0x021B }, // # LATIN CAPITAL LETTER T WITH COMMA BELOW
   { 0x021C, /* C, */ 0x021D }, // # LATIN CAPITAL LETTER YOGH
   { 0x021E, /* C, */ 0x021F }, // # LATIN CAPITAL LETTER H WITH CARON
   { 0x0220, /* C, */ 0x019E }, // # LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
   { 0x0222, /* C, */ 0x0223 }, // # LATIN CAPITAL LETTER OU
   { 0x0224, /* C, */ 0x0225 }, // # LATIN CAPITAL LETTER Z WITH HOOK
   { 0x0226, /* C, */ 0x0227 }, // # LATIN CAPITAL LETTER A WITH DOT ABOVE
   { 0x0228, /* C, */ 0x0229 }, // # LATIN CAPITAL LETTER E WITH CEDILLA
   { 0x022A, /* C, */ 0x022B }, // # LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
   { 0x022C, /* C, */ 0x022D }, // # LATIN CAPITAL LETTER O WITH TILDE AND MACRON
   { 0x022E, /* C, */ 0x022F }, // # LATIN CAPITAL LETTER O WITH DOT ABOVE
   { 0x0230, /* C, */ 0x0231 }, // # LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
   { 0x0232, /* C, */ 0x0233 }, // # LATIN CAPITAL LETTER Y WITH MACRON
   { 0x023A, /* C, */ 0x2C65 }, // # LATIN CAPITAL LETTER A WITH STROKE
   { 0x023B, /* C, */ 0x023C }, // # LATIN CAPITAL LETTER C WITH STROKE
   { 0x023D, /* C, */ 0x019A }, // # LATIN CAPITAL LETTER L WITH BAR
   { 0x023E, /* C, */ 0x2C66 }, // # LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
   { 0x0241, /* C, */ 0x0242 }, // # LATIN CAPITAL LETTER GLOTTAL STOP
   { 0x0243, /* C, */ 0x0180 }, // # LATIN CAPITAL LETTER B WITH STROKE
   { 0x0244, /* C, */ 0x0289 }, // # LATIN CAPITAL LETTER U BAR
   { 0x0245, /* C, */ 0x028C }, // # LATIN CAPITAL LETTER TURNED V
   { 0x0246, /* C, */ 0x0247 }, // # LATIN CAPITAL LETTER E WITH STROKE
   { 0x0248, /* C, */ 0x0249 }, // # LATIN CAPITAL LETTER J WITH STROKE
   { 0x024A, /* C, */ 0x024B }, // # LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
   { 0x024C, /* C, */ 0x024D }, // # LATIN CAPITAL LETTER R WITH STROKE
   { 0x024E, /* C, */ 0x024F }, // # LATIN CAPITAL LETTER Y WITH STROKE
   { 0x0345, /* C, */ 0x03B9 }, // # COMBINING GREEK YPOGEGRAMMENI
   { 0x0370, /* C, */ 0x0371 }, // # GREEK CAPITAL LETTER HETA
   { 0x0372, /* C, */ 0x0373 }, // # GREEK CAPITAL LETTER ARCHAIC SAMPI
   { 0x0376, /* C, */ 0x0377 }, // # GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
   { 0x037F, /* C, */ 0x03F3 }, // # GREEK CAPITAL LETTER YOT
   { 0x0386, /* C, */ 0x03AC }, // # GREEK CAPITAL LETTER ALPHA WITH TONOS
   { 0x0388, /* C, */ 0x03AD }, // # GREEK CAPITAL LETTER EPSILON WITH TONOS
   { 0x0389, /* C, */ 0x03AE }, // # GREEK CAPITAL LETTER ETA WITH TONOS
   { 0x038A, /* C, */ 0x03AF }, // # GREEK CAPITAL LETTER IOTA WITH TONOS
   { 0x038C, /* C, */ 0x03CC }, // # GREEK CAPITAL LETTER OMICRON WITH TONOS
   { 0x038E, /* C, */ 0x03CD }, // # GREEK CAPITAL LETTER UPSILON WITH TONOS
   { 0x038F, /* C, */ 0x03CE }, // # GREEK CAPITAL LETTER OMEGA WITH TONOS
   { 0x0391, /* C, */ 0x03B1 }, // # GREEK CAPITAL LETTER ALPHA
   { 0x0392, /* C, */ 0x03B2 }, // # GREEK CAPITAL LETTER BETA
   { 0x0393, /* C, */ 0x03B3 }, // # GREEK CAPITAL LETTER GAMMA
   { 0x0394, /* C, */ 0x03B4 }, // # GREEK CAPITAL LETTER DELTA
   { 0x0395, /* C, */ 0x03B5 }, // # GREEK CAPITAL LETTER EPSILON
   { 0x0396, /* C, */ 0x03B6 }, // # GREEK CAPITAL LETTER ZETA
   { 0x0397, /* C, */ 0x03B7 }, // # GREEK CAPITAL LETTER ETA
   { 0x0398, /* C, */ 0x03B8 }, // # GREEK CAPITAL LETTER THETA
   { 0x0399, /* C, */ 0x03B9 }, // # GREEK CAPITAL LETTER IOTA
   { 0x039A, /* C, */ 0x03BA }, // # GREEK CAPITAL LETTER KAPPA
   { 0x039B, /* C, */ 0x03BB }, // # GREEK CAPITAL LETTER LAMDA
   { 0x039C, /* C, */ 0x03BC }, // # GREEK CAPITAL LETTER MU
   { 0x039D, /* C, */ 0x03BD }, // # GREEK CAPITAL LETTER NU
   { 0x039E, /* C, */ 0x03BE }, // # GREEK CAPITAL LETTER XI
   { 0x039F, /* C, */ 0x03BF }, // # GREEK CAPITAL LETTER OMICRON
   { 0x03A0, /* C, */ 0x03C0 }, // # GREEK CAPITAL LETTER PI
   { 0x03A1, /* C, */ 0x03C1 }, // # GREEK CAPITAL LETTER RHO
   { 0x03A3, /* C, */ 0x03C3 }, // # GREEK CAPITAL LETTER SIGMA
   { 0x03A4, /* C, */ 0x03C4 }, // # GREEK CAPITAL LETTER TAU
   { 0x03A5, /* C, */ 0x03C5 }, // # GREEK CAPITAL LETTER UPSILON
   { 0x03A6, /* C, */ 0x03C6 }, // # GREEK CAPITAL LETTER PHI
   { 0x03A7, /* C, */ 0x03C7 }, // # GREEK CAPITAL LETTER CHI
   { 0x03A8, /* C, */ 0x03C8 }, // # GREEK CAPITAL LETTER PSI
   { 0x03A9, /* C, */ 0x03C9 }, // # GREEK CAPITAL LETTER OMEGA
   { 0x03AA, /* C, */ 0x03CA }, // # GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
   { 0x03AB, /* C, */ 0x03CB }, // # GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
   { 0x03C2, /* C, */ 0x03C3 }, // # GREEK SMALL LETTER FINAL SIGMA
   { 0x03CF, /* C, */ 0x03D7 }, // # GREEK CAPITAL KAI SYMBOL
   { 0x03D0, /* C, */ 0x03B2 }, // # GREEK BETA SYMBOL
   { 0x03D1, /* C, */ 0x03B8 }, // # GREEK THETA SYMBOL
   { 0x03D5, /* C, */ 0x03C6 }, // # GREEK PHI SYMBOL
   { 0x03D6, /* C, */ 0x03C0 }, // # GREEK PI SYMBOL
   { 0x03D8, /* C, */ 0x03D9 }, // # GREEK LETTER ARCHAIC KOPPA
   { 0x03DA, /* C, */ 0x03DB }, // # GREEK LETTER STIGMA
   { 0x03DC, /* C, */ 0x03DD }, // # GREEK LETTER DIGAMMA
   { 0x03DE, /* C, */ 0x03DF }, // # GREEK LETTER KOPPA
   { 0x03E0, /* C, */ 0x03E1 }, // # GREEK LETTER SAMPI
   { 0x03E2, /* C, */ 0x03E3 }, // # COPTIC CAPITAL LETTER SHEI
   { 0x03E4, /* C, */ 0x03E5 }, // # COPTIC CAPITAL LETTER FEI
   { 0x03E6, /* C, */ 0x03E7 }, // # COPTIC CAPITAL LETTER KHEI
   { 0x03E8, /* C, */ 0x03E9 }, // # COPTIC CAPITAL LETTER HORI
   { 0x03EA, /* C, */ 0x03EB }, // # COPTIC CAPITAL LETTER GANGIA
   { 0x03EC, /* C, */ 0x03ED }, // # COPTIC CAPITAL LETTER SHIMA
   { 0x03EE, /* C, */ 0x03EF }, // # COPTIC CAPITAL LETTER DEI
   { 0x03F0, /* C, */ 0x03BA }, // # GREEK KAPPA SYMBOL
   { 0x03F1, /* C, */ 0x03C1 }, // # GREEK RHO SYMBOL
   { 0x03F4, /* C, */ 0x03B8 }, // # GREEK CAPITAL THETA SYMBOL
   { 0x03F5, /* C, */ 0x03B5 }, // # GREEK LUNATE EPSILON SYMBOL
   { 0x03F7, /* C, */ 0x03F8 }, // # GREEK CAPITAL LETTER SHO
   { 0x03F9, /* C, */ 0x03F2 }, // # GREEK CAPITAL LUNATE SIGMA SYMBOL
   { 0x03FA, /* C, */ 0x03FB }, // # GREEK CAPITAL LETTER SAN
   { 0x03FD, /* C, */ 0x037B }, // # GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL
   { 0x03FE, /* C, */ 0x037C }, // # GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL
   { 0x03FF, /* C, */ 0x037D }, // # GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL
   { 0x0400, /* C, */ 0x0450 }, // # CYRILLIC CAPITAL LETTER IE WITH GRAVE
   { 0x0401, /* C, */ 0x0451 }, // # CYRILLIC CAPITAL LETTER IO
   { 0x0402, /* C, */ 0x0452 }, // # CYRILLIC CAPITAL LETTER DJE
   { 0x0403, /* C, */ 0x0453 }, // # CYRILLIC CAPITAL LETTER GJE
   { 0x0404, /* C, */ 0x0454 }, // # CYRILLIC CAPITAL LETTER UKRAINIAN IE
   { 0x0405, /* C, */ 0x0455 }, // # CYRILLIC CAPITAL LETTER DZE
   { 0x0406, /* C, */ 0x0456 }, // # CYRILLIC CAPITAL LETTER BYELORUSSIAN - UKRAINIAN I
   { 0x0407, /* C, */ 0x0457 }, // # CYRILLIC CAPITAL LETTER YI
   { 0x0408, /* C, */ 0x0458 }, // # CYRILLIC CAPITAL LETTER JE
   { 0x0409, /* C, */ 0x0459 }, // # CYRILLIC CAPITAL LETTER LJE
   { 0x040A, /* C, */ 0x045A }, // # CYRILLIC CAPITAL LETTER NJE
   { 0x040B, /* C, */ 0x045B }, // # CYRILLIC CAPITAL LETTER TSHE
   { 0x040C, /* C, */ 0x045C }, // # CYRILLIC CAPITAL LETTER KJE
   { 0x040D, /* C, */ 0x045D }, // # CYRILLIC CAPITAL LETTER I WITH GRAVE
   { 0x040E, /* C, */ 0x045E }, // # CYRILLIC CAPITAL LETTER SHORT U
   { 0x040F, /* C, */ 0x045F }, // # CYRILLIC CAPITAL LETTER DZHE
   { 0x0410, /* C, */ 0x0430 }, // # CYRILLIC CAPITAL LETTER A
   { 0x0411, /* C, */ 0x0431 }, // # CYRILLIC CAPITAL LETTER BE
   { 0x0412, /* C, */ 0x0432 }, // # CYRILLIC CAPITAL LETTER VE
   { 0x0413, /* C, */ 0x0433 }, // # CYRILLIC CAPITAL LETTER GHE
   { 0x0414, /* C, */ 0x0434 }, // # CYRILLIC CAPITAL LETTER DE
   { 0x0415, /* C, */ 0x0435 }, // # CYRILLIC CAPITAL LETTER IE
   { 0x0416, /* C, */ 0x0436 }, // # CYRILLIC CAPITAL LETTER ZHE
   { 0x0417, /* C, */ 0x0437 }, // # CYRILLIC CAPITAL LETTER ZE
   { 0x0418, /* C, */ 0x0438 }, // # CYRILLIC CAPITAL LETTER I
   { 0x0419, /* C, */ 0x0439 }, // # CYRILLIC CAPITAL LETTER SHORT I
   { 0x041A, /* C, */ 0x043A }, // # CYRILLIC CAPITAL LETTER KA
   { 0x041B, /* C, */ 0x043B }, // # CYRILLIC CAPITAL LETTER EL
   { 0x041C, /* C, */ 0x043C }, // # CYRILLIC CAPITAL LETTER EM
   { 0x041D, /* C, */ 0x043D }, // # CYRILLIC CAPITAL LETTER EN
   { 0x041E, /* C, */ 0x043E }, // # CYRILLIC CAPITAL LETTER O
   { 0x041F, /* C, */ 0x043F }, // # CYRILLIC CAPITAL LETTER PE
   { 0x0420, /* C, */ 0x0440 }, // # CYRILLIC CAPITAL LETTER ER
   { 0x0421, /* C, */ 0x0441 }, // # CYRILLIC CAPITAL LETTER ES
   { 0x0422, /* C, */ 0x0442 }, // # CYRILLIC CAPITAL LETTER TE
   { 0x0423, /* C, */ 0x0443 }, // # CYRILLIC CAPITAL LETTER U
   { 0x0424, /* C, */ 0x0444 }, // # CYRILLIC CAPITAL LETTER EF
   { 0x0425, /* C, */ 0x0445 }, // # CYRILLIC CAPITAL LETTER HA
   { 0x0426, /* C, */ 0x0446 }, // # CYRILLIC CAPITAL LETTER TSE
   { 0x0427, /* C, */ 0x0447 }, // # CYRILLIC CAPITAL LETTER CHE
   { 0x0428, /* C, */ 0x0448 }, // # CYRILLIC CAPITAL LETTER SHA
   { 0x0429, /* C, */ 0x0449 }, // # CYRILLIC CAPITAL LETTER SHCHA
   { 0x042A, /* C, */ 0x044A }, // # CYRILLIC CAPITAL LETTER HARD SIGN
   { 0x042B, /* C, */ 0x044B }, // # CYRILLIC CAPITAL LETTER YERU
   { 0x042C, /* C, */ 0x044C }, // # CYRILLIC CAPITAL LETTER SOFT SIGN
   { 0x042D, /* C, */ 0x044D }, // # CYRILLIC CAPITAL LETTER E
   { 0x042E, /* C, */ 0x044E }, // # CYRILLIC CAPITAL LETTER YU
   { 0x042F, /* C, */ 0x044F }, // # CYRILLIC CAPITAL LETTER YA
   { 0x0460, /* C, */ 0x0461 }, // # CYRILLIC CAPITAL LETTER OMEGA
   { 0x0462, /* C, */ 0x0463 }, // # CYRILLIC CAPITAL LETTER YAT
   { 0x0464, /* C, */ 0x0465 }, // # CYRILLIC CAPITAL LETTER IOTIFIED E
   { 0x0466, /* C, */ 0x0467 }, // # CYRILLIC CAPITAL LETTER LITTLE YUS
   { 0x0468, /* C, */ 0x0469 }, // # CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
   { 0x046A, /* C, */ 0x046B }, // # CYRILLIC CAPITAL LETTER BIG YUS
   { 0x046C, /* C, */ 0x046D }, // # CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
   { 0x046E, /* C, */ 0x046F }, // # CYRILLIC CAPITAL LETTER KSI
   { 0x0470, /* C, */ 0x0471 }, // # CYRILLIC CAPITAL LETTER PSI
   { 0x0472, /* C, */ 0x0473 }, // # CYRILLIC CAPITAL LETTER FITA
   { 0x0474, /* C, */ 0x0475 }, // # CYRILLIC CAPITAL LETTER IZHITSA
   { 0x0476, /* C, */ 0x0477 }, // # CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
   { 0x0478, /* C, */ 0x0479 }, // # CYRILLIC CAPITAL LETTER UK
   { 0x047A, /* C, */ 0x047B }, // # CYRILLIC CAPITAL LETTER ROUND OMEGA
   { 0x047C, /* C, */ 0x047D }, // # CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
   { 0x047E, /* C, */ 0x047F }, // # CYRILLIC CAPITAL LETTER OT
   { 0x0480, /* C, */ 0x0481 }, // # CYRILLIC CAPITAL LETTER KOPPA
   { 0x048A, /* C, */ 0x048B }, // # CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
   { 0x048C, /* C, */ 0x048D }, // # CYRILLIC CAPITAL LETTER SEMISOFT SIGN
   { 0x048E, /* C, */ 0x048F }, // # CYRILLIC CAPITAL LETTER ER WITH TICK
   { 0x0490, /* C, */ 0x0491 }, // # CYRILLIC CAPITAL LETTER GHE WITH UPTURN
   { 0x0492, /* C, */ 0x0493 }, // # CYRILLIC CAPITAL LETTER GHE WITH STROKE
   { 0x0494, /* C, */ 0x0495 }, // # CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
   { 0x0496, /* C, */ 0x0497 }, // # CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
   { 0x0498, /* C, */ 0x0499 }, // # CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
   { 0x049A, /* C, */ 0x049B }, // # CYRILLIC CAPITAL LETTER KA WITH DESCENDER
   { 0x049C, /* C, */ 0x049D }, // # CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
   { 0x049E, /* C, */ 0x049F }, // # CYRILLIC CAPITAL LETTER KA WITH STROKE
   { 0x04A0, /* C, */ 0x04A1 }, // # CYRILLIC CAPITAL LETTER BASHKIR KA
   { 0x04A2, /* C, */ 0x04A3 }, // # CYRILLIC CAPITAL LETTER EN WITH DESCENDER
   { 0x04A4, /* C, */ 0x04A5 }, // # CYRILLIC CAPITAL LIGATURE EN GHE
   { 0x04A6, /* C, */ 0x04A7 }, // # CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
   { 0x04A8, /* C, */ 0x04A9 }, // # CYRILLIC CAPITAL LETTER ABKHASIAN HA
   { 0x04AA, /* C, */ 0x04AB }, // # CYRILLIC CAPITAL LETTER ES WITH DESCENDER
   { 0x04AC, /* C, */ 0x04AD }, // # CYRILLIC CAPITAL LETTER TE WITH DESCENDER
   { 0x04AE, /* C, */ 0x04AF }, // # CYRILLIC CAPITAL LETTER STRAIGHT U
   { 0x04B0, /* C, */ 0x04B1 }, // # CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
   { 0x04B2, /* C, */ 0x04B3 }, // # CYRILLIC CAPITAL LETTER HA WITH DESCENDER
   { 0x04B4, /* C, */ 0x04B5 }, // # CYRILLIC CAPITAL LIGATURE TE TSE
   { 0x04B6, /* C, */ 0x04B7 }, // # CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
   { 0x04B8, /* C, */ 0x04B9 }, // # CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
   { 0x04BA, /* C, */ 0x04BB }, // # CYRILLIC CAPITAL LETTER SHHA
   { 0x04BC, /* C, */ 0x04BD }, // # CYRILLIC CAPITAL LETTER ABKHASIAN CHE
   { 0x04BE, /* C, */ 0x04BF }, // # CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
   { 0x04C0, /* C, */ 0x04CF }, // # CYRILLIC LETTER PALOCHKA
   { 0x04C1, /* C, */ 0x04C2 }, // # CYRILLIC CAPITAL LETTER ZHE WITH BREVE
   { 0x04C3, /* C, */ 0x04C4 }, // # CYRILLIC CAPITAL LETTER KA WITH HOOK
   { 0x04C5, /* C, */ 0x04C6 }, // # CYRILLIC CAPITAL LETTER EL WITH TAIL
   { 0x04C7, /* C, */ 0x04C8 }, // # CYRILLIC CAPITAL LETTER EN WITH HOOK
   { 0x04C9, /* C, */ 0x04CA }, // # CYRILLIC CAPITAL LETTER EN WITH TAIL
   { 0x04CB, /* C, */ 0x04CC }, // # CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
   { 0x04CD, /* C, */ 0x04CE }, // # CYRILLIC CAPITAL LETTER EM WITH TAIL
   { 0x04D0, /* C, */ 0x04D1 }, // # CYRILLIC CAPITAL LETTER A WITH BREVE
   { 0x04D2, /* C, */ 0x04D3 }, // # CYRILLIC CAPITAL LETTER A WITH DIAERESIS
   { 0x04D4, /* C, */ 0x04D5 }, // # CYRILLIC CAPITAL LIGATURE A IE
   { 0x04D6, /* C, */ 0x04D7 }, // # CYRILLIC CAPITAL LETTER IE WITH BREVE
   { 0x04D8, /* C, */ 0x04D9 }, // # CYRILLIC CAPITAL LETTER SCHWA
   { 0x04DA, /* C, */ 0x04DB }, // # CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
   { 0x04DC, /* C, */ 0x04DD }, // # CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
   { 0x04DE, /* C, */ 0x04DF }, // # CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
   { 0x04E0, /* C, */ 0x04E1 }, // # CYRILLIC CAPITAL LETTER ABKHASIAN DZE
   { 0x04E2, /* C, */ 0x04E3 }, // # CYRILLIC CAPITAL LETTER I WITH MACRON
   { 0x04E4, /* C, */ 0x04E5 }, // # CYRILLIC CAPITAL LETTER I WITH DIAERESIS
   { 0x04E6, /* C, */ 0x04E7 }, // # CYRILLIC CAPITAL LETTER O WITH DIAERESIS
   { 0x04E8, /* C, */ 0x04E9 }, // # CYRILLIC CAPITAL LETTER BARRED O
   { 0x04EA, /* C, */ 0x04EB }, // # CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
   { 0x04EC, /* C, */ 0x04ED }, // # CYRILLIC CAPITAL LETTER E WITH DIAERESIS
   { 0x04EE, /* C, */ 0x04EF }, // # CYRILLIC CAPITAL LETTER U WITH MACRON
   { 0x04F0, /* C, */ 0x04F1 }, // # CYRILLIC CAPITAL LETTER U WITH DIAERESIS
   { 0x04F2, /* C, */ 0x04F3 }, // # CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
   { 0x04F4, /* C, */ 0x04F5 }, // # CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
   { 0x04F6, /* C, */ 0x04F7 }, // # CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
   { 0x04F8, /* C, */ 0x04F9 }, // # CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
   { 0x04FA, /* C, */ 0x04FB }, // # CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
   { 0x04FC, /* C, */ 0x04FD }, // # CYRILLIC CAPITAL LETTER HA WITH HOOK
   { 0x04FE, /* C, */ 0x04FF }, // # CYRILLIC CAPITAL LETTER HA WITH STROKE
   { 0x0500, /* C, */ 0x0501 }, // # CYRILLIC CAPITAL LETTER KOMI DE
   { 0x0502, /* C, */ 0x0503 }, // # CYRILLIC CAPITAL LETTER KOMI DJE
   { 0x0504, /* C, */ 0x0505 }, // # CYRILLIC CAPITAL LETTER KOMI ZJE
   { 0x0506, /* C, */ 0x0507 }, // # CYRILLIC CAPITAL LETTER KOMI DZJE
   { 0x0508, /* C, */ 0x0509 }, // # CYRILLIC CAPITAL LETTER KOMI LJE
   { 0x050A, /* C, */ 0x050B }, // # CYRILLIC CAPITAL LETTER KOMI NJE
   { 0x050C, /* C, */ 0x050D }, // # CYRILLIC CAPITAL LETTER KOMI SJE
   { 0x050E, /* C, */ 0x050F }, // # CYRILLIC CAPITAL LETTER KOMI TJE
   { 0x0510, /* C, */ 0x0511 }, // # CYRILLIC CAPITAL LETTER REVERSED ZE
   { 0x0512, /* C, */ 0x0513 }, // # CYRILLIC CAPITAL LETTER EL WITH HOOK
   { 0x0514, /* C, */ 0x0515 }, // # CYRILLIC CAPITAL LETTER LHA
   { 0x0516, /* C, */ 0x0517 }, // # CYRILLIC CAPITAL LETTER RHA
   { 0x0518, /* C, */ 0x0519 }, // # CYRILLIC CAPITAL LETTER YAE
   { 0x051A, /* C, */ 0x051B }, // # CYRILLIC CAPITAL LETTER QA
   { 0x051C, /* C, */ 0x051D }, // # CYRILLIC CAPITAL LETTER WE
   { 0x051E, /* C, */ 0x051F }, // # CYRILLIC CAPITAL LETTER ALEUT KA
   { 0x0520, /* C, */ 0x0521 }, // # CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
   { 0x0522, /* C, */ 0x0523 }, // # CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
   { 0x0524, /* C, */ 0x0525 }, // # CYRILLIC CAPITAL LETTER PE WITH DESCENDER
   { 0x0526, /* C, */ 0x0527 }, // # CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
   { 0x0528, /* C, */ 0x0529 }, // # CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK
   { 0x052A, /* C, */ 0x052B }, // # CYRILLIC CAPITAL LETTER DZZHE
   { 0x052C, /* C, */ 0x052D }, // # CYRILLIC CAPITAL LETTER DCHE
   { 0x052E, /* C, */ 0x052F }, // # CYRILLIC CAPITAL LETTER EL WITH DESCENDER
   { 0x0531, /* C, */ 0x0561 }, // # ARMENIAN CAPITAL LETTER AYB
   { 0x0532, /* C, */ 0x0562 }, // # ARMENIAN CAPITAL LETTER BEN
   { 0x0533, /* C, */ 0x0563 }, // # ARMENIAN CAPITAL LETTER GIM
   { 0x0534, /* C, */ 0x0564 }, // # ARMENIAN CAPITAL LETTER DA
   { 0x0535, /* C, */ 0x0565 }, // # ARMENIAN CAPITAL LETTER ECH
   { 0x0536, /* C, */ 0x0566 }, // # ARMENIAN CAPITAL LETTER ZA
   { 0x0537, /* C, */ 0x0567 }, // # ARMENIAN CAPITAL LETTER EH
   { 0x0538, /* C, */ 0x0568 }, // # ARMENIAN CAPITAL LETTER ET
   { 0x0539, /* C, */ 0x0569 }, // # ARMENIAN CAPITAL LETTER TO
   { 0x053A, /* C, */ 0x056A }, // # ARMENIAN CAPITAL LETTER ZHE
   { 0x053B, /* C, */ 0x056B }, // # ARMENIAN CAPITAL LETTER INI
   { 0x053C, /* C, */ 0x056C }, // # ARMENIAN CAPITAL LETTER LIWN
   { 0x053D, /* C, */ 0x056D }, // # ARMENIAN CAPITAL LETTER XEH
   { 0x053E, /* C, */ 0x056E }, // # ARMENIAN CAPITAL LETTER CA
   { 0x053F, /* C, */ 0x056F }, // # ARMENIAN CAPITAL LETTER KEN
   { 0x0540, /* C, */ 0x0570 }, // # ARMENIAN CAPITAL LETTER HO
   { 0x0541, /* C, */ 0x0571 }, // # ARMENIAN CAPITAL LETTER JA
   { 0x0542, /* C, */ 0x0572 }, // # ARMENIAN CAPITAL LETTER GHAD
   { 0x0543, /* C, */ 0x0573 }, // # ARMENIAN CAPITAL LETTER CHEH
   { 0x0544, /* C, */ 0x0574 }, // # ARMENIAN CAPITAL LETTER MEN
   { 0x0545, /* C, */ 0x0575 }, // # ARMENIAN CAPITAL LETTER YI
   { 0x0546, /* C, */ 0x0576 }, // # ARMENIAN CAPITAL LETTER NOW
   { 0x0547, /* C, */ 0x0577 }, // # ARMENIAN CAPITAL LETTER SHA
   { 0x0548, /* C, */ 0x0578 }, // # ARMENIAN CAPITAL LETTER VO
   { 0x0549, /* C, */ 0x0579 }, // # ARMENIAN CAPITAL LETTER CHA
   { 0x054A, /* C, */ 0x057A }, // # ARMENIAN CAPITAL LETTER PEH
   { 0x054B, /* C, */ 0x057B }, // # ARMENIAN CAPITAL LETTER JHEH
   { 0x054C, /* C, */ 0x057C }, // # ARMENIAN CAPITAL LETTER RA
   { 0x054D, /* C, */ 0x057D }, // # ARMENIAN CAPITAL LETTER SEH
   { 0x054E, /* C, */ 0x057E }, // # ARMENIAN CAPITAL LETTER VEW
   { 0x054F, /* C, */ 0x057F }, // # ARMENIAN CAPITAL LETTER TIWN
   { 0x0550, /* C, */ 0x0580 }, // # ARMENIAN CAPITAL LETTER REH
   { 0x0551, /* C, */ 0x0581 }, // # ARMENIAN CAPITAL LETTER CO
   { 0x0552, /* C, */ 0x0582 }, // # ARMENIAN CAPITAL LETTER YIWN
   { 0x0553, /* C, */ 0x0583 }, // # ARMENIAN CAPITAL LETTER PIWR
   { 0x0554, /* C, */ 0x0584 }, // # ARMENIAN CAPITAL LETTER KEH
   { 0x0555, /* C, */ 0x0585 }, // # ARMENIAN CAPITAL LETTER OH
   { 0x0556, /* C, */ 0x0586 }, // # ARMENIAN CAPITAL LETTER FEH
   { 0x10A0, /* C, */ 0x2D00 }, // # GEORGIAN CAPITAL LETTER AN
   { 0x10A1, /* C, */ 0x2D01 }, // # GEORGIAN CAPITAL LETTER BAN
   { 0x10A2, /* C, */ 0x2D02 }, // # GEORGIAN CAPITAL LETTER GAN
   { 0x10A3, /* C, */ 0x2D03 }, // # GEORGIAN CAPITAL LETTER DON
   { 0x10A4, /* C, */ 0x2D04 }, // # GEORGIAN CAPITAL LETTER EN
   { 0x10A5, /* C, */ 0x2D05 }, // # GEORGIAN CAPITAL LETTER VIN
   { 0x10A6, /* C, */ 0x2D06 }, // # GEORGIAN CAPITAL LETTER ZEN
   { 0x10A7, /* C, */ 0x2D07 }, // # GEORGIAN CAPITAL LETTER TAN
   { 0x10A8, /* C, */ 0x2D08 }, // # GEORGIAN CAPITAL LETTER IN
   { 0x10A9, /* C, */ 0x2D09 }, // # GEORGIAN CAPITAL LETTER KAN
   { 0x10AA, /* C, */ 0x2D0A }, // # GEORGIAN CAPITAL LETTER LAS
   { 0x10AB, /* C, */ 0x2D0B }, // # GEORGIAN CAPITAL LETTER MAN
   { 0x10AC, /* C, */ 0x2D0C }, // # GEORGIAN CAPITAL LETTER NAR
   { 0x10AD, /* C, */ 0x2D0D }, // # GEORGIAN CAPITAL LETTER ON
   { 0x10AE, /* C, */ 0x2D0E }, // # GEORGIAN CAPITAL LETTER PAR
   { 0x10AF, /* C, */ 0x2D0F }, // # GEORGIAN CAPITAL LETTER ZHAR
   { 0x10B0, /* C, */ 0x2D10 }, // # GEORGIAN CAPITAL LETTER RAE
   { 0x10B1, /* C, */ 0x2D11 }, // # GEORGIAN CAPITAL LETTER SAN
   { 0x10B2, /* C, */ 0x2D12 }, // # GEORGIAN CAPITAL LETTER TAR
   { 0x10B3, /* C, */ 0x2D13 }, // # GEORGIAN CAPITAL LETTER UN
   { 0x10B4, /* C, */ 0x2D14 }, // # GEORGIAN CAPITAL LETTER PHAR
   { 0x10B5, /* C, */ 0x2D15 }, // # GEORGIAN CAPITAL LETTER KHAR
   { 0x10B6, /* C, */ 0x2D16 }, // # GEORGIAN CAPITAL LETTER GHAN
   { 0x10B7, /* C, */ 0x2D17 }, // # GEORGIAN CAPITAL LETTER QAR
   { 0x10B8, /* C, */ 0x2D18 }, // # GEORGIAN CAPITAL LETTER SHIN
   { 0x10B9, /* C, */ 0x2D19 }, // # GEORGIAN CAPITAL LETTER CHIN
   { 0x10BA, /* C, */ 0x2D1A }, // # GEORGIAN CAPITAL LETTER CAN
   { 0x10BB, /* C, */ 0x2D1B }, // # GEORGIAN CAPITAL LETTER JIL
   { 0x10BC, /* C, */ 0x2D1C }, // # GEORGIAN CAPITAL LETTER CIL
   { 0x10BD, /* C, */ 0x2D1D }, // # GEORGIAN CAPITAL LETTER CHAR
   { 0x10BE, /* C, */ 0x2D1E }, // # GEORGIAN CAPITAL LETTER XAN
   { 0x10BF, /* C, */ 0x2D1F }, // # GEORGIAN CAPITAL LETTER JHAN
   { 0x10C0, /* C, */ 0x2D20 }, // # GEORGIAN CAPITAL LETTER HAE
   { 0x10C1, /* C, */ 0x2D21 }, // # GEORGIAN CAPITAL LETTER HE
   { 0x10C2, /* C, */ 0x2D22 }, // # GEORGIAN CAPITAL LETTER HIE
   { 0x10C3, /* C, */ 0x2D23 }, // # GEORGIAN CAPITAL LETTER WE
   { 0x10C4, /* C, */ 0x2D24 }, // # GEORGIAN CAPITAL LETTER HAR
   { 0x10C5, /* C, */ 0x2D25 }, // # GEORGIAN CAPITAL LETTER HOE
   { 0x10C7, /* C, */ 0x2D27 }, // # GEORGIAN CAPITAL LETTER YN
   { 0x10CD, /* C, */ 0x2D2D }, // # GEORGIAN CAPITAL LETTER AEN
   { 0x13F8, /* C, */ 0x13F0 }, // # CHEROKEE SMALL LETTER YE
   { 0x13F9, /* C, */ 0x13F1 }, // # CHEROKEE SMALL LETTER YI
   { 0x13FA, /* C, */ 0x13F2 }, // # CHEROKEE SMALL LETTER YO
   { 0x13FB, /* C, */ 0x13F3 }, // # CHEROKEE SMALL LETTER YU
   { 0x13FC, /* C, */ 0x13F4 }, // # CHEROKEE SMALL LETTER YV
   { 0x13FD, /* C, */ 0x13F5 }, // # CHEROKEE SMALL LETTER MV
   { 0x1C80, /* C, */ 0x0432 }, // # CYRILLIC SMALL LETTER ROUNDED VE
   { 0x1C81, /* C, */ 0x0434 }, // # CYRILLIC SMALL LETTER LONG - LEGGED DE
   { 0x1C82, /* C, */ 0x043E }, // # CYRILLIC SMALL LETTER NARROW O
   { 0x1C83, /* C, */ 0x0441 }, // # CYRILLIC SMALL LETTER WIDE ES
   { 0x1C84, /* C, */ 0x0442 }, // # CYRILLIC SMALL LETTER TALL TE
   { 0x1C85, /* C, */ 0x0442 }, // # CYRILLIC SMALL LETTER THREE - LEGGED TE
   { 0x1C86, /* C, */ 0x044A }, // # CYRILLIC SMALL LETTER TALL HARD SIGN
   { 0x1C87, /* C, */ 0x0463 }, // # CYRILLIC SMALL LETTER TALL YAT
   { 0x1C88, /* C, */ 0xA64B }, // # CYRILLIC SMALL LETTER UNBLENDED UK
   { 0x1C90, /* C, */ 0x10D0 }, // # GEORGIAN MTAVRULI CAPITAL LETTER AN
   { 0x1C91, /* C, */ 0x10D1 }, // # GEORGIAN MTAVRULI CAPITAL LETTER BAN
   { 0x1C92, /* C, */ 0x10D2 }, // # GEORGIAN MTAVRULI CAPITAL LETTER GAN
   { 0x1C93, /* C, */ 0x10D3 }, // # GEORGIAN MTAVRULI CAPITAL LETTER DON
   { 0x1C94, /* C, */ 0x10D4 }, // # GEORGIAN MTAVRULI CAPITAL LETTER EN
   { 0x1C95, /* C, */ 0x10D5 }, // # GEORGIAN MTAVRULI CAPITAL LETTER VIN
   { 0x1C96, /* C, */ 0x10D6 }, // # GEORGIAN MTAVRULI CAPITAL LETTER ZEN
   { 0x1C97, /* C, */ 0x10D7 }, // # GEORGIAN MTAVRULI CAPITAL LETTER TAN
   { 0x1C98, /* C, */ 0x10D8 }, // # GEORGIAN MTAVRULI CAPITAL LETTER IN
   { 0x1C99, /* C, */ 0x10D9 }, // # GEORGIAN MTAVRULI CAPITAL LETTER KAN
   { 0x1C9A, /* C, */ 0x10DA }, // # GEORGIAN MTAVRULI CAPITAL LETTER LAS
   { 0x1C9B, /* C, */ 0x10DB }, // # GEORGIAN MTAVRULI CAPITAL LETTER MAN
   { 0x1C9C, /* C, */ 0x10DC }, // # GEORGIAN MTAVRULI CAPITAL LETTER NAR
   { 0x1C9D, /* C, */ 0x10DD }, // # GEORGIAN MTAVRULI CAPITAL LETTER ON
   { 0x1C9E, /* C, */ 0x10DE }, // # GEORGIAN MTAVRULI CAPITAL LETTER PAR
   { 0x1C9F, /* C, */ 0x10DF }, // # GEORGIAN MTAVRULI CAPITAL LETTER ZHAR
   { 0x1CA0, /* C, */ 0x10E0 }, // # GEORGIAN MTAVRULI CAPITAL LETTER RAE
   { 0x1CA1, /* C, */ 0x10E1 }, // # GEORGIAN MTAVRULI CAPITAL LETTER SAN
   { 0x1CA2, /* C, */ 0x10E2 }, // # GEORGIAN MTAVRULI CAPITAL LETTER TAR
   { 0x1CA3, /* C, */ 0x10E3 }, // # GEORGIAN MTAVRULI CAPITAL LETTER UN
   { 0x1CA4, /* C, */ 0x10E4 }, // # GEORGIAN MTAVRULI CAPITAL LETTER PHAR
   { 0x1CA5, /* C, */ 0x10E5 }, // # GEORGIAN MTAVRULI CAPITAL LETTER KHAR
   { 0x1CA6, /* C, */ 0x10E6 }, // # GEORGIAN MTAVRULI CAPITAL LETTER GHAN
   { 0x1CA7, /* C, */ 0x10E7 }, // # GEORGIAN MTAVRULI CAPITAL LETTER QAR
   { 0x1CA8, /* C, */ 0x10E8 }, // # GEORGIAN MTAVRULI CAPITAL LETTER SHIN
   { 0x1CA9, /* C, */ 0x10E9 }, // # GEORGIAN MTAVRULI CAPITAL LETTER CHIN
   { 0x1CAA, /* C, */ 0x10EA }, // # GEORGIAN MTAVRULI CAPITAL LETTER CAN
   { 0x1CAB, /* C, */ 0x10EB }, // # GEORGIAN MTAVRULI CAPITAL LETTER JIL
   { 0x1CAC, /* C, */ 0x10EC }, // # GEORGIAN MTAVRULI CAPITAL LETTER CIL
   { 0x1CAD, /* C, */ 0x10ED }, // # GEORGIAN MTAVRULI CAPITAL LETTER CHAR
   { 0x1CAE, /* C, */ 0x10EE }, // # GEORGIAN MTAVRULI CAPITAL LETTER XAN
   { 0x1CAF, /* C, */ 0x10EF }, // # GEORGIAN MTAVRULI CAPITAL LETTER JHAN
   { 0x1CB0, /* C, */ 0x10F0 }, // # GEORGIAN MTAVRULI CAPITAL LETTER HAE
   { 0x1CB1, /* C, */ 0x10F1 }, // # GEORGIAN MTAVRULI CAPITAL LETTER HE
   { 0x1CB2, /* C, */ 0x10F2 }, // # GEORGIAN MTAVRULI CAPITAL LETTER HIE
   { 0x1CB3, /* C, */ 0x10F3 }, // # GEORGIAN MTAVRULI CAPITAL LETTER WE
   { 0x1CB4, /* C, */ 0x10F4 }, // # GEORGIAN MTAVRULI CAPITAL LETTER HAR
   { 0x1CB5, /* C, */ 0x10F5 }, // # GEORGIAN MTAVRULI CAPITAL LETTER HOE
   { 0x1CB6, /* C, */ 0x10F6 }, // # GEORGIAN MTAVRULI CAPITAL LETTER FI
   { 0x1CB7, /* C, */ 0x10F7 }, // # GEORGIAN MTAVRULI CAPITAL LETTER YN
   { 0x1CB8, /* C, */ 0x10F8 }, // # GEORGIAN MTAVRULI CAPITAL LETTER ELIFI
   { 0x1CB9, /* C, */ 0x10F9 }, // # GEORGIAN MTAVRULI CAPITAL LETTER TURNED GAN
   { 0x1CBA, /* C, */ 0x10FA }, // # GEORGIAN MTAVRULI CAPITAL LETTER AIN
   { 0x1CBD, /* C, */ 0x10FD }, // # GEORGIAN MTAVRULI CAPITAL LETTER AEN
   { 0x1CBE, /* C, */ 0x10FE }, // # GEORGIAN MTAVRULI CAPITAL LETTER HARD SIGN
   { 0x1CBF, /* C, */ 0x10FF }, // # GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
   { 0x1E00, /* C, */ 0x1E01 }, // # LATIN CAPITAL LETTER A WITH RING BELOW
   { 0x1E02, /* C, */ 0x1E03 }, // # LATIN CAPITAL LETTER B WITH DOT ABOVE
   { 0x1E04, /* C, */ 0x1E05 }, // # LATIN CAPITAL LETTER B WITH DOT BELOW
   { 0x1E06, /* C, */ 0x1E07 }, // # LATIN CAPITAL LETTER B WITH LINE BELOW
   { 0x1E08, /* C, */ 0x1E09 }, // # LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
   { 0x1E0A, /* C, */ 0x1E0B }, // # LATIN CAPITAL LETTER D WITH DOT ABOVE
   { 0x1E0C, /* C, */ 0x1E0D }, // # LATIN CAPITAL LETTER D WITH DOT BELOW
   { 0x1E0E, /* C, */ 0x1E0F }, // # LATIN CAPITAL LETTER D WITH LINE BELOW
   { 0x1E10, /* C, */ 0x1E11 }, // # LATIN CAPITAL LETTER D WITH CEDILLA
   { 0x1E12, /* C, */ 0x1E13 }, // # LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
   { 0x1E14, /* C, */ 0x1E15 }, // # LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
   { 0x1E16, /* C, */ 0x1E17 }, // # LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
   { 0x1E18, /* C, */ 0x1E19 }, // # LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
   { 0x1E1A, /* C, */ 0x1E1B }, // # LATIN CAPITAL LETTER E WITH TILDE BELOW
   { 0x1E1C, /* C, */ 0x1E1D }, // # LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
   { 0x1E1E, /* C, */ 0x1E1F }, // # LATIN CAPITAL LETTER F WITH DOT ABOVE
   { 0x1E20, /* C, */ 0x1E21 }, // # LATIN CAPITAL LETTER G WITH MACRON
   { 0x1E22, /* C, */ 0x1E23 }, // # LATIN CAPITAL LETTER H WITH DOT ABOVE
   { 0x1E24, /* C, */ 0x1E25 }, // # LATIN CAPITAL LETTER H WITH DOT BELOW
   { 0x1E26, /* C, */ 0x1E27 }, // # LATIN CAPITAL LETTER H WITH DIAERESIS
   { 0x1E28, /* C, */ 0x1E29 }, // # LATIN CAPITAL LETTER H WITH CEDILLA
   { 0x1E2A, /* C, */ 0x1E2B }, // # LATIN CAPITAL LETTER H WITH BREVE BELOW
   { 0x1E2C, /* C, */ 0x1E2D }, // # LATIN CAPITAL LETTER I WITH TILDE BELOW
   { 0x1E2E, /* C, */ 0x1E2F }, // # LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
   { 0x1E30, /* C, */ 0x1E31 }, // # LATIN CAPITAL LETTER K WITH ACUTE
   { 0x1E32, /* C, */ 0x1E33 }, // # LATIN CAPITAL LETTER K WITH DOT BELOW
   { 0x1E34, /* C, */ 0x1E35 }, // # LATIN CAPITAL LETTER K WITH LINE BELOW
   { 0x1E36, /* C, */ 0x1E37 }, // # LATIN CAPITAL LETTER L WITH DOT BELOW
   { 0x1E38, /* C, */ 0x1E39 }, // # LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
   { 0x1E3A, /* C, */ 0x1E3B }, // # LATIN CAPITAL LETTER L WITH LINE BELOW
   { 0x1E3C, /* C, */ 0x1E3D }, // # LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
   { 0x1E3E, /* C, */ 0x1E3F }, // # LATIN CAPITAL LETTER M WITH ACUTE
   { 0x1E40, /* C, */ 0x1E41 }, // # LATIN CAPITAL LETTER M WITH DOT ABOVE
   { 0x1E42, /* C, */ 0x1E43 }, // # LATIN CAPITAL LETTER M WITH DOT BELOW
   { 0x1E44, /* C, */ 0x1E45 }, // # LATIN CAPITAL LETTER N WITH DOT ABOVE
   { 0x1E46, /* C, */ 0x1E47 }, // # LATIN CAPITAL LETTER N WITH DOT BELOW
   { 0x1E48, /* C, */ 0x1E49 }, // # LATIN CAPITAL LETTER N WITH LINE BELOW
   { 0x1E4A, /* C, */ 0x1E4B }, // # LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
   { 0x1E4C, /* C, */ 0x1E4D }, // # LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
   { 0x1E4E, /* C, */ 0x1E4F }, // # LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
   { 0x1E50, /* C, */ 0x1E51 }, // # LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
   { 0x1E52, /* C, */ 0x1E53 }, // # LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
   { 0x1E54, /* C, */ 0x1E55 }, // # LATIN CAPITAL LETTER P WITH ACUTE
   { 0x1E56, /* C, */ 0x1E57 }, // # LATIN CAPITAL LETTER P WITH DOT ABOVE
   { 0x1E58, /* C, */ 0x1E59 }, // # LATIN CAPITAL LETTER R WITH DOT ABOVE
   { 0x1E5A, /* C, */ 0x1E5B }, // # LATIN CAPITAL LETTER R WITH DOT BELOW
   { 0x1E5C, /* C, */ 0x1E5D }, // # LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
   { 0x1E5E, /* C, */ 0x1E5F }, // # LATIN CAPITAL LETTER R WITH LINE BELOW
   { 0x1E60, /* C, */ 0x1E61 }, // # LATIN CAPITAL LETTER S WITH DOT ABOVE
   { 0x1E62, /* C, */ 0x1E63 }, // # LATIN CAPITAL LETTER S WITH DOT BELOW
   { 0x1E64, /* C, */ 0x1E65 }, // # LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
   { 0x1E66, /* C, */ 0x1E67 }, // # LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
   { 0x1E68, /* C, */ 0x1E69 }, // # LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
   { 0x1E6A, /* C, */ 0x1E6B }, // # LATIN CAPITAL LETTER T WITH DOT ABOVE
   { 0x1E6C, /* C, */ 0x1E6D }, // # LATIN CAPITAL LETTER T WITH DOT BELOW
   { 0x1E6E, /* C, */ 0x1E6F }, // # LATIN CAPITAL LETTER T WITH LINE BELOW
   { 0x1E70, /* C, */ 0x1E71 }, // # LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
   { 0x1E72, /* C, */ 0x1E73 }, // # LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
   { 0x1E74, /* C, */ 0x1E75 }, // # LATIN CAPITAL LETTER U WITH TILDE BELOW
   { 0x1E76, /* C, */ 0x1E77 }, // # LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
   { 0x1E78, /* C, */ 0x1E79 }, // # LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
   { 0x1E7A, /* C, */ 0x1E7B }, // # LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
   { 0x1E7C, /* C, */ 0x1E7D }, // # LATIN CAPITAL LETTER V WITH TILDE
   { 0x1E7E, /* C, */ 0x1E7F }, // # LATIN CAPITAL LETTER V WITH DOT BELOW
   { 0x1E80, /* C, */ 0x1E81 }, // # LATIN CAPITAL LETTER W WITH GRAVE
   { 0x1E82, /* C, */ 0x1E83 }, // # LATIN CAPITAL LETTER W WITH ACUTE
   { 0x1E84, /* C, */ 0x1E85 }, // # LATIN CAPITAL LETTER W WITH DIAERESIS
   { 0x1E86, /* C, */ 0x1E87 }, // # LATIN CAPITAL LETTER W WITH DOT ABOVE
   { 0x1E88, /* C, */ 0x1E89 }, // # LATIN CAPITAL LETTER W WITH DOT BELOW
   { 0x1E8A, /* C, */ 0x1E8B }, // # LATIN CAPITAL LETTER X WITH DOT ABOVE
   { 0x1E8C, /* C, */ 0x1E8D }, // # LATIN CAPITAL LETTER X WITH DIAERESIS
   { 0x1E8E, /* C, */ 0x1E8F }, // # LATIN CAPITAL LETTER Y WITH DOT ABOVE
   { 0x1E90, /* C, */ 0x1E91 }, // # LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
   { 0x1E92, /* C, */ 0x1E93 }, // # LATIN CAPITAL LETTER Z WITH DOT BELOW
   { 0x1E94, /* C, */ 0x1E95 }, // # LATIN CAPITAL LETTER Z WITH LINE BELOW
   { 0x1E9B, /* C, */ 0x1E61 }, // # LATIN SMALL LETTER LONG S WITH DOT ABOVE
   { 0x1E9E, /* S, */ 0x00DF }, // # LATIN CAPITAL LETTER SHARP S
   { 0x1EA0, /* C, */ 0x1EA1 }, // # LATIN CAPITAL LETTER A WITH DOT BELOW
   { 0x1EA2, /* C, */ 0x1EA3 }, // # LATIN CAPITAL LETTER A WITH HOOK ABOVE
   { 0x1EA4, /* C, */ 0x1EA5 }, // # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
   { 0x1EA6, /* C, */ 0x1EA7 }, // # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
   { 0x1EA8, /* C, */ 0x1EA9 }, // # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
   { 0x1EAA, /* C, */ 0x1EAB }, // # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
   { 0x1EAC, /* C, */ 0x1EAD }, // # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
   { 0x1EAE, /* C, */ 0x1EAF }, // # LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
   { 0x1EB0, /* C, */ 0x1EB1 }, // # LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
   { 0x1EB2, /* C, */ 0x1EB3 }, // # LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
   { 0x1EB4, /* C, */ 0x1EB5 }, // # LATIN CAPITAL LETTER A WITH BREVE AND TILDE
   { 0x1EB6, /* C, */ 0x1EB7 }, // # LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
   { 0x1EB8, /* C, */ 0x1EB9 }, // # LATIN CAPITAL LETTER E WITH DOT BELOW
   { 0x1EBA, /* C, */ 0x1EBB }, // # LATIN CAPITAL LETTER E WITH HOOK ABOVE
   { 0x1EBC, /* C, */ 0x1EBD }, // # LATIN CAPITAL LETTER E WITH TILDE
   { 0x1EBE, /* C, */ 0x1EBF }, // # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
   { 0x1EC0, /* C, */ 0x1EC1 }, // # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
   { 0x1EC2, /* C, */ 0x1EC3 }, // # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
   { 0x1EC4, /* C, */ 0x1EC5 }, // # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
   { 0x1EC6, /* C, */ 0x1EC7 }, // # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
   { 0x1EC8, /* C, */ 0x1EC9 }, // # LATIN CAPITAL LETTER I WITH HOOK ABOVE
   { 0x1ECA, /* C, */ 0x1ECB }, // # LATIN CAPITAL LETTER I WITH DOT BELOW
   { 0x1ECC, /* C, */ 0x1ECD }, // # LATIN CAPITAL LETTER O WITH DOT BELOW
   { 0x1ECE, /* C, */ 0x1ECF }, // # LATIN CAPITAL LETTER O WITH HOOK ABOVE
   { 0x1ED0, /* C, */ 0x1ED1 }, // # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
   { 0x1ED2, /* C, */ 0x1ED3 }, // # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
   { 0x1ED4, /* C, */ 0x1ED5 }, // # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
   { 0x1ED6, /* C, */ 0x1ED7 }, // # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
   { 0x1ED8, /* C, */ 0x1ED9 }, // # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
   { 0x1EDA, /* C, */ 0x1EDB }, // # LATIN CAPITAL LETTER O WITH HORN AND ACUTE
   { 0x1EDC, /* C, */ 0x1EDD }, // # LATIN CAPITAL LETTER O WITH HORN AND GRAVE
   { 0x1EDE, /* C, */ 0x1EDF }, // # LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
   { 0x1EE0, /* C, */ 0x1EE1 }, // # LATIN CAPITAL LETTER O WITH HORN AND TILDE
   { 0x1EE2, /* C, */ 0x1EE3 }, // # LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
   { 0x1EE4, /* C, */ 0x1EE5 }, // # LATIN CAPITAL LETTER U WITH DOT BELOW
   { 0x1EE6, /* C, */ 0x1EE7 }, // # LATIN CAPITAL LETTER U WITH HOOK ABOVE
   { 0x1EE8, /* C, */ 0x1EE9 }, // # LATIN CAPITAL LETTER U WITH HORN AND ACUTE
   { 0x1EEA, /* C, */ 0x1EEB }, // # LATIN CAPITAL LETTER U WITH HORN AND GRAVE
   { 0x1EEC, /* C, */ 0x1EED }, // # LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
   { 0x1EEE, /* C, */ 0x1EEF }, // # LATIN CAPITAL LETTER U WITH HORN AND TILDE
   { 0x1EF0, /* C, */ 0x1EF1 }, // # LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
   { 0x1EF2, /* C, */ 0x1EF3 }, // # LATIN CAPITAL LETTER Y WITH GRAVE
   { 0x1EF4, /* C, */ 0x1EF5 }, // # LATIN CAPITAL LETTER Y WITH DOT BELOW
   { 0x1EF6, /* C, */ 0x1EF7 }, // # LATIN CAPITAL LETTER Y WITH HOOK ABOVE
   { 0x1EF8, /* C, */ 0x1EF9 }, // # LATIN CAPITAL LETTER Y WITH TILDE
   { 0x1EFA, /* C, */ 0x1EFB }, // # LATIN CAPITAL LETTER MIDDLE - WELSH LL
   { 0x1EFC, /* C, */ 0x1EFD }, // # LATIN CAPITAL LETTER MIDDLE - WELSH V
   { 0x1EFE, /* C, */ 0x1EFF }, // # LATIN CAPITAL LETTER Y WITH LOOP
   { 0x1F08, /* C, */ 0x1F00 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI
   { 0x1F09, /* C, */ 0x1F01 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA
   { 0x1F0A, /* C, */ 0x1F02 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
   { 0x1F0B, /* C, */ 0x1F03 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
   { 0x1F0C, /* C, */ 0x1F04 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
   { 0x1F0D, /* C, */ 0x1F05 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
   { 0x1F0E, /* C, */ 0x1F06 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
   { 0x1F0F, /* C, */ 0x1F07 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
   { 0x1F18, /* C, */ 0x1F10 }, // # GREEK CAPITAL LETTER EPSILON WITH PSILI
   { 0x1F19, /* C, */ 0x1F11 }, // # GREEK CAPITAL LETTER EPSILON WITH DASIA
   { 0x1F1A, /* C, */ 0x1F12 }, // # GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
   { 0x1F1B, /* C, */ 0x1F13 }, // # GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
   { 0x1F1C, /* C, */ 0x1F14 }, // # GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
   { 0x1F1D, /* C, */ 0x1F15 }, // # GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
   { 0x1F28, /* C, */ 0x1F20 }, // # GREEK CAPITAL LETTER ETA WITH PSILI
   { 0x1F29, /* C, */ 0x1F21 }, // # GREEK CAPITAL LETTER ETA WITH DASIA
   { 0x1F2A, /* C, */ 0x1F22 }, // # GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
   { 0x1F2B, /* C, */ 0x1F23 }, // # GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
   { 0x1F2C, /* C, */ 0x1F24 }, // # GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
   { 0x1F2D, /* C, */ 0x1F25 }, // # GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
   { 0x1F2E, /* C, */ 0x1F26 }, // # GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
   { 0x1F2F, /* C, */ 0x1F27 }, // # GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
   { 0x1F38, /* C, */ 0x1F30 }, // # GREEK CAPITAL LETTER IOTA WITH PSILI
   { 0x1F39, /* C, */ 0x1F31 }, // # GREEK CAPITAL LETTER IOTA WITH DASIA
   { 0x1F3A, /* C, */ 0x1F32 }, // # GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
   { 0x1F3B, /* C, */ 0x1F33 }, // # GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
   { 0x1F3C, /* C, */ 0x1F34 }, // # GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
   { 0x1F3D, /* C, */ 0x1F35 }, // # GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
   { 0x1F3E, /* C, */ 0x1F36 }, // # GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
   { 0x1F3F, /* C, */ 0x1F37 }, // # GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
   { 0x1F48, /* C, */ 0x1F40 }, // # GREEK CAPITAL LETTER OMICRON WITH PSILI
   { 0x1F49, /* C, */ 0x1F41 }, // # GREEK CAPITAL LETTER OMICRON WITH DASIA
   { 0x1F4A, /* C, */ 0x1F42 }, // # GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
   { 0x1F4B, /* C, */ 0x1F43 }, // # GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
   { 0x1F4C, /* C, */ 0x1F44 }, // # GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
   { 0x1F4D, /* C, */ 0x1F45 }, // # GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
   { 0x1F59, /* C, */ 0x1F51 }, // # GREEK CAPITAL LETTER UPSILON WITH DASIA
   { 0x1F5B, /* C, */ 0x1F53 }, // # GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
   { 0x1F5D, /* C, */ 0x1F55 }, // # GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
   { 0x1F5F, /* C, */ 0x1F57 }, // # GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
   { 0x1F68, /* C, */ 0x1F60 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI
   { 0x1F69, /* C, */ 0x1F61 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA
   { 0x1F6A, /* C, */ 0x1F62 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
   { 0x1F6B, /* C, */ 0x1F63 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
   { 0x1F6C, /* C, */ 0x1F64 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
   { 0x1F6D, /* C, */ 0x1F65 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
   { 0x1F6E, /* C, */ 0x1F66 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
   { 0x1F6F, /* C, */ 0x1F67 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
   { 0x1F88, /* S, */ 0x1F80 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
   { 0x1F89, /* S, */ 0x1F81 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
   { 0x1F8A, /* S, */ 0x1F82 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
   { 0x1F8B, /* S, */ 0x1F83 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
   { 0x1F8C, /* S, */ 0x1F84 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
   { 0x1F8D, /* S, */ 0x1F85 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
   { 0x1F8E, /* S, */ 0x1F86 }, // # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
   { 0x1F8F, /* S, */ 0x1F87 }, // # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
   { 0x1F98, /* S, */ 0x1F90 }, // # GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
   { 0x1F99, /* S, */ 0x1F91 }, // # GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
   { 0x1F9A, /* S, */ 0x1F92 }, // # GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
   { 0x1F9B, /* S, */ 0x1F93 }, // # GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
   { 0x1F9C, /* S, */ 0x1F94 }, // # GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
   { 0x1F9D, /* S, */ 0x1F95 }, // # GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
   { 0x1F9E, /* S, */ 0x1F96 }, // # GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
   { 0x1F9F, /* S, */ 0x1F97 }, // # GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
   { 0x1FA8, /* S, */ 0x1FA0 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
   { 0x1FA9, /* S, */ 0x1FA1 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
   { 0x1FAA, /* S, */ 0x1FA2 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
   { 0x1FAB, /* S, */ 0x1FA3 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
   { 0x1FAC, /* S, */ 0x1FA4 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
   { 0x1FAD, /* S, */ 0x1FA5 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
   { 0x1FAE, /* S, */ 0x1FA6 }, // # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
   { 0x1FAF, /* S, */ 0x1FA7 }, // # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
   { 0x1FB8, /* C, */ 0x1FB0 }, // # GREEK CAPITAL LETTER ALPHA WITH VRACHY
   { 0x1FB9, /* C, */ 0x1FB1 }, // # GREEK CAPITAL LETTER ALPHA WITH MACRON
   { 0x1FBA, /* C, */ 0x1F70 }, // # GREEK CAPITAL LETTER ALPHA WITH VARIA
   { 0x1FBB, /* C, */ 0x1F71 }, // # GREEK CAPITAL LETTER ALPHA WITH OXIA
   { 0x1FBC, /* S, */ 0x1FB3 }, // # GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
   { 0x1FBE, /* C, */ 0x03B9 }, // # GREEK PROSGEGRAMMENI
   { 0x1FC8, /* C, */ 0x1F72 }, // # GREEK CAPITAL LETTER EPSILON WITH VARIA
   { 0x1FC9, /* C, */ 0x1F73 }, // # GREEK CAPITAL LETTER EPSILON WITH OXIA
   { 0x1FCA, /* C, */ 0x1F74 }, // # GREEK CAPITAL LETTER ETA WITH VARIA
   { 0x1FCB, /* C, */ 0x1F75 }, // # GREEK CAPITAL LETTER ETA WITH OXIA
   { 0x1FCC, /* S, */ 0x1FC3 }, // # GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
   { 0x1FD8, /* C, */ 0x1FD0 }, // # GREEK CAPITAL LETTER IOTA WITH VRACHY
   { 0x1FD9, /* C, */ 0x1FD1 }, // # GREEK CAPITAL LETTER IOTA WITH MACRON
   { 0x1FDA, /* C, */ 0x1F76 }, // # GREEK CAPITAL LETTER IOTA WITH VARIA
   { 0x1FDB, /* C, */ 0x1F77 }, // # GREEK CAPITAL LETTER IOTA WITH OXIA
   { 0x1FE8, /* C, */ 0x1FE0 }, // # GREEK CAPITAL LETTER UPSILON WITH VRACHY
   { 0x1FE9, /* C, */ 0x1FE1 }, // # GREEK CAPITAL LETTER UPSILON WITH MACRON
   { 0x1FEA, /* C, */ 0x1F7A }, // # GREEK CAPITAL LETTER UPSILON WITH VARIA
   { 0x1FEB, /* C, */ 0x1F7B }, // # GREEK CAPITAL LETTER UPSILON WITH OXIA
   { 0x1FEC, /* C, */ 0x1FE5 }, // # GREEK CAPITAL LETTER RHO WITH DASIA
   { 0x1FF8, /* C, */ 0x1F78 }, // # GREEK CAPITAL LETTER OMICRON WITH VARIA
   { 0x1FF9, /* C, */ 0x1F79 }, // # GREEK CAPITAL LETTER OMICRON WITH OXIA
   { 0x1FFA, /* C, */ 0x1F7C }, // # GREEK CAPITAL LETTER OMEGA WITH VARIA
   { 0x1FFB, /* C, */ 0x1F7D }, // # GREEK CAPITAL LETTER OMEGA WITH OXIA
   { 0x1FFC, /* S, */ 0x1FF3 }, // # GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
   { 0x2126, /* C, */ 0x03C9 }, // # OHM SIGN
   { 0x212A, /* C, */ 0x006B }, // # KELVIN SIGN
   { 0x212B, /* C, */ 0x00E5 }, // # ANGSTROM SIGN
   { 0x2132, /* C, */ 0x214E }, // # TURNED CAPITAL F
   { 0x2160, /* C, */ 0x2170 }, // # ROMAN NUMERAL ONE
   { 0x2161, /* C, */ 0x2171 }, // # ROMAN NUMERAL TWO
   { 0x2162, /* C, */ 0x2172 }, // # ROMAN NUMERAL THREE
   { 0x2163, /* C, */ 0x2173 }, // # ROMAN NUMERAL FOUR
   { 0x2164, /* C, */ 0x2174 }, // # ROMAN NUMERAL FIVE
   { 0x2165, /* C, */ 0x2175 }, // # ROMAN NUMERAL SIX
   { 0x2166, /* C, */ 0x2176 }, // # ROMAN NUMERAL SEVEN
   { 0x2167, /* C, */ 0x2177 }, // # ROMAN NUMERAL EIGHT
   { 0x2168, /* C, */ 0x2178 }, // # ROMAN NUMERAL NINE
   { 0x2169, /* C, */ 0x2179 }, // # ROMAN NUMERAL TEN
   { 0x216A, /* C, */ 0x217A }, // # ROMAN NUMERAL ELEVEN
   { 0x216B, /* C, */ 0x217B }, // # ROMAN NUMERAL TWELVE
   { 0x216C, /* C, */ 0x217C }, // # ROMAN NUMERAL FIFTY
   { 0x216D, /* C, */ 0x217D }, // # ROMAN NUMERAL ONE HUNDRED
   { 0x216E, /* C, */ 0x217E }, // # ROMAN NUMERAL FIVE HUNDRED
   { 0x216F, /* C, */ 0x217F }, // # ROMAN NUMERAL ONE THOUSAND
   { 0x2183, /* C, */ 0x2184 }, // # ROMAN NUMERAL REVERSED ONE HUNDRED
   { 0x24B6, /* C, */ 0x24D0 }, // # CIRCLED LATIN CAPITAL LETTER A
   { 0x24B7, /* C, */ 0x24D1 }, // # CIRCLED LATIN CAPITAL LETTER B
   { 0x24B8, /* C, */ 0x24D2 }, // # CIRCLED LATIN CAPITAL LETTER C
   { 0x24B9, /* C, */ 0x24D3 }, // # CIRCLED LATIN CAPITAL LETTER D
   { 0x24BA, /* C, */ 0x24D4 }, // # CIRCLED LATIN CAPITAL LETTER E
   { 0x24BB, /* C, */ 0x24D5 }, // # CIRCLED LATIN CAPITAL LETTER F
   { 0x24BC, /* C, */ 0x24D6 }, // # CIRCLED LATIN CAPITAL LETTER G
   { 0x24BD, /* C, */ 0x24D7 }, // # CIRCLED LATIN CAPITAL LETTER H
   { 0x24BE, /* C, */ 0x24D8 }, // # CIRCLED LATIN CAPITAL LETTER I
   { 0x24BF, /* C, */ 0x24D9 }, // # CIRCLED LATIN CAPITAL LETTER J
   { 0x24C0, /* C, */ 0x24DA }, // # CIRCLED LATIN CAPITAL LETTER K
   { 0x24C1, /* C, */ 0x24DB }, // # CIRCLED LATIN CAPITAL LETTER L
   { 0x24C2, /* C, */ 0x24DC }, // # CIRCLED LATIN CAPITAL LETTER M
   { 0x24C3, /* C, */ 0x24DD }, // # CIRCLED LATIN CAPITAL LETTER N
   { 0x24C4, /* C, */ 0x24DE }, // # CIRCLED LATIN CAPITAL LETTER O
   { 0x24C5, /* C, */ 0x24DF }, // # CIRCLED LATIN CAPITAL LETTER P
   { 0x24C6, /* C, */ 0x24E0 }, // # CIRCLED LATIN CAPITAL LETTER Q
   { 0x24C7, /* C, */ 0x24E1 }, // # CIRCLED LATIN CAPITAL LETTER R
   { 0x24C8, /* C, */ 0x24E2 }, // # CIRCLED LATIN CAPITAL LETTER S
   { 0x24C9, /* C, */ 0x24E3 }, // # CIRCLED LATIN CAPITAL LETTER T
   { 0x24CA, /* C, */ 0x24E4 }, // # CIRCLED LATIN CAPITAL LETTER U
   { 0x24CB, /* C, */ 0x24E5 }, // # CIRCLED LATIN CAPITAL LETTER V
   { 0x24CC, /* C, */ 0x24E6 }, // # CIRCLED LATIN CAPITAL LETTER W
   { 0x24CD, /* C, */ 0x24E7 }, // # CIRCLED LATIN CAPITAL LETTER X
   { 0x24CE, /* C, */ 0x24E8 }, // # CIRCLED LATIN CAPITAL LETTER Y
   { 0x24CF, /* C, */ 0x24E9 }, // # CIRCLED LATIN CAPITAL LETTER Z
   { 0x2C00, /* C, */ 0x2C30 }, // # GLAGOLITIC CAPITAL LETTER AZU
   { 0x2C01, /* C, */ 0x2C31 }, // # GLAGOLITIC CAPITAL LETTER BUKY
   { 0x2C02, /* C, */ 0x2C32 }, // # GLAGOLITIC CAPITAL LETTER VEDE
   { 0x2C03, /* C, */ 0x2C33 }, // # GLAGOLITIC CAPITAL LETTER GLAGOLI
   { 0x2C04, /* C, */ 0x2C34 }, // # GLAGOLITIC CAPITAL LETTER DOBRO
   { 0x2C05, /* C, */ 0x2C35 }, // # GLAGOLITIC CAPITAL LETTER YESTU
   { 0x2C06, /* C, */ 0x2C36 }, // # GLAGOLITIC CAPITAL LETTER ZHIVETE
   { 0x2C07, /* C, */ 0x2C37 }, // # GLAGOLITIC CAPITAL LETTER DZELO
   { 0x2C08, /* C, */ 0x2C38 }, // # GLAGOLITIC CAPITAL LETTER ZEMLJA
   { 0x2C09, /* C, */ 0x2C39 }, // # GLAGOLITIC CAPITAL LETTER IZHE
   { 0x2C0A, /* C, */ 0x2C3A }, // # GLAGOLITIC CAPITAL LETTER INITIAL IZHE
   { 0x2C0B, /* C, */ 0x2C3B }, // # GLAGOLITIC CAPITAL LETTER I
   { 0x2C0C, /* C, */ 0x2C3C }, // # GLAGOLITIC CAPITAL LETTER DJERVI
   { 0x2C0D, /* C, */ 0x2C3D }, // # GLAGOLITIC CAPITAL LETTER KAKO
   { 0x2C0E, /* C, */ 0x2C3E }, // # GLAGOLITIC CAPITAL LETTER LJUDIJE
   { 0x2C0F, /* C, */ 0x2C3F }, // # GLAGOLITIC CAPITAL LETTER MYSLITE
   { 0x2C10, /* C, */ 0x2C40 }, // # GLAGOLITIC CAPITAL LETTER NASHI
   { 0x2C11, /* C, */ 0x2C41 }, // # GLAGOLITIC CAPITAL LETTER ONU
   { 0x2C12, /* C, */ 0x2C42 }, // # GLAGOLITIC CAPITAL LETTER POKOJI
   { 0x2C13, /* C, */ 0x2C43 }, // # GLAGOLITIC CAPITAL LETTER RITSI
   { 0x2C14, /* C, */ 0x2C44 }, // # GLAGOLITIC CAPITAL LETTER SLOVO
   { 0x2C15, /* C, */ 0x2C45 }, // # GLAGOLITIC CAPITAL LETTER TVRIDO
   { 0x2C16, /* C, */ 0x2C46 }, // # GLAGOLITIC CAPITAL LETTER UKU
   { 0x2C17, /* C, */ 0x2C47 }, // # GLAGOLITIC CAPITAL LETTER FRITU
   { 0x2C18, /* C, */ 0x2C48 }, // # GLAGOLITIC CAPITAL LETTER HERU
   { 0x2C19, /* C, */ 0x2C49 }, // # GLAGOLITIC CAPITAL LETTER OTU
   { 0x2C1A, /* C, */ 0x2C4A }, // # GLAGOLITIC CAPITAL LETTER PE
   { 0x2C1B, /* C, */ 0x2C4B }, // # GLAGOLITIC CAPITAL LETTER SHTA
   { 0x2C1C, /* C, */ 0x2C4C }, // # GLAGOLITIC CAPITAL LETTER TSI
   { 0x2C1D, /* C, */ 0x2C4D }, // # GLAGOLITIC CAPITAL LETTER CHRIVI
   { 0x2C1E, /* C, */ 0x2C4E }, // # GLAGOLITIC CAPITAL LETTER SHA
   { 0x2C1F, /* C, */ 0x2C4F }, // # GLAGOLITIC CAPITAL LETTER YERU
   { 0x2C20, /* C, */ 0x2C50 }, // # GLAGOLITIC CAPITAL LETTER YERI
   { 0x2C21, /* C, */ 0x2C51 }, // # GLAGOLITIC CAPITAL LETTER YATI
   { 0x2C22, /* C, */ 0x2C52 }, // # GLAGOLITIC CAPITAL LETTER SPIDERY HA
   { 0x2C23, /* C, */ 0x2C53 }, // # GLAGOLITIC CAPITAL LETTER YU
   { 0x2C24, /* C, */ 0x2C54 }, // # GLAGOLITIC CAPITAL LETTER SMALL YUS
   { 0x2C25, /* C, */ 0x2C55 }, // # GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL
   { 0x2C26, /* C, */ 0x2C56 }, // # GLAGOLITIC CAPITAL LETTER YO
   { 0x2C27, /* C, */ 0x2C57 }, // # GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS
   { 0x2C28, /* C, */ 0x2C58 }, // # GLAGOLITIC CAPITAL LETTER BIG YUS
   { 0x2C29, /* C, */ 0x2C59 }, // # GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS
   { 0x2C2A, /* C, */ 0x2C5A }, // # GLAGOLITIC CAPITAL LETTER FITA
   { 0x2C2B, /* C, */ 0x2C5B }, // # GLAGOLITIC CAPITAL LETTER IZHITSA
   { 0x2C2C, /* C, */ 0x2C5C }, // # GLAGOLITIC CAPITAL LETTER SHTAPIC
   { 0x2C2D, /* C, */ 0x2C5D }, // # GLAGOLITIC CAPITAL LETTER TROKUTASTI A
   { 0x2C2E, /* C, */ 0x2C5E }, // # GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
   { 0x2C60, /* C, */ 0x2C61 }, // # LATIN CAPITAL LETTER L WITH DOUBLE BAR
   { 0x2C62, /* C, */ 0x026B }, // # LATIN CAPITAL LETTER L WITH MIDDLE TILDE
   { 0x2C63, /* C, */ 0x1D7D }, // # LATIN CAPITAL LETTER P WITH STROKE
   { 0x2C64, /* C, */ 0x027D }, // # LATIN CAPITAL LETTER R WITH TAIL
   { 0x2C67, /* C, */ 0x2C68 }, // # LATIN CAPITAL LETTER H WITH DESCENDER
   { 0x2C69, /* C, */ 0x2C6A }, // # LATIN CAPITAL LETTER K WITH DESCENDER
   { 0x2C6B, /* C, */ 0x2C6C }, // # LATIN CAPITAL LETTER Z WITH DESCENDER
   { 0x2C6D, /* C, */ 0x0251 }, // # LATIN CAPITAL LETTER ALPHA
   { 0x2C6E, /* C, */ 0x0271 }, // # LATIN CAPITAL LETTER M WITH HOOK
   { 0x2C6F, /* C, */ 0x0250 }, // # LATIN CAPITAL LETTER TURNED A
   { 0x2C70, /* C, */ 0x0252 }, // # LATIN CAPITAL LETTER TURNED ALPHA
   { 0x2C72, /* C, */ 0x2C73 }, // # LATIN CAPITAL LETTER W WITH HOOK
   { 0x2C75, /* C, */ 0x2C76 }, // # LATIN CAPITAL LETTER HALF H
   { 0x2C7E, /* C, */ 0x023F }, // # LATIN CAPITAL LETTER S WITH SWASH TAIL
   { 0x2C7F, /* C, */ 0x0240 }, // # LATIN CAPITAL LETTER Z WITH SWASH TAIL
   { 0x2C80, /* C, */ 0x2C81 }, // # COPTIC CAPITAL LETTER ALFA
   { 0x2C82, /* C, */ 0x2C83 }, // # COPTIC CAPITAL LETTER VIDA
   { 0x2C84, /* C, */ 0x2C85 }, // # COPTIC CAPITAL LETTER GAMMA
   { 0x2C86, /* C, */ 0x2C87 }, // # COPTIC CAPITAL LETTER DALDA
   { 0x2C88, /* C, */ 0x2C89 }, // # COPTIC CAPITAL LETTER EIE
   { 0x2C8A, /* C, */ 0x2C8B }, // # COPTIC CAPITAL LETTER SOU
   { 0x2C8C, /* C, */ 0x2C8D }, // # COPTIC CAPITAL LETTER ZATA
   { 0x2C8E, /* C, */ 0x2C8F }, // # COPTIC CAPITAL LETTER HATE
   { 0x2C90, /* C, */ 0x2C91 }, // # COPTIC CAPITAL LETTER THETHE
   { 0x2C92, /* C, */ 0x2C93 }, // # COPTIC CAPITAL LETTER IAUDA
   { 0x2C94, /* C, */ 0x2C95 }, // # COPTIC CAPITAL LETTER KAPA
   { 0x2C96, /* C, */ 0x2C97 }, // # COPTIC CAPITAL LETTER LAULA
   { 0x2C98, /* C, */ 0x2C99 }, // # COPTIC CAPITAL LETTER MI
   { 0x2C9A, /* C, */ 0x2C9B }, // # COPTIC CAPITAL LETTER NI
   { 0x2C9C, /* C, */ 0x2C9D }, // # COPTIC CAPITAL LETTER KSI
   { 0x2C9E, /* C, */ 0x2C9F }, // # COPTIC CAPITAL LETTER O
   { 0x2CA0, /* C, */ 0x2CA1 }, // # COPTIC CAPITAL LETTER PI
   { 0x2CA2, /* C, */ 0x2CA3 }, // # COPTIC CAPITAL LETTER RO
   { 0x2CA4, /* C, */ 0x2CA5 }, // # COPTIC CAPITAL LETTER SIMA
   { 0x2CA6, /* C, */ 0x2CA7 }, // # COPTIC CAPITAL LETTER TAU
   { 0x2CA8, /* C, */ 0x2CA9 }, // # COPTIC CAPITAL LETTER UA
   { 0x2CAA, /* C, */ 0x2CAB }, // # COPTIC CAPITAL LETTER FI
   { 0x2CAC, /* C, */ 0x2CAD }, // # COPTIC CAPITAL LETTER KHI
   { 0x2CAE, /* C, */ 0x2CAF }, // # COPTIC CAPITAL LETTER PSI
   { 0x2CB0, /* C, */ 0x2CB1 }, // # COPTIC CAPITAL LETTER OOU
   { 0x2CB2, /* C, */ 0x2CB3 }, // # COPTIC CAPITAL LETTER DIALECT - P ALEF
   { 0x2CB4, /* C, */ 0x2CB5 }, // # COPTIC CAPITAL LETTER OLD COPTIC AIN
   { 0x2CB6, /* C, */ 0x2CB7 }, // # COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
   { 0x2CB8, /* C, */ 0x2CB9 }, // # COPTIC CAPITAL LETTER DIALECT - P KAPA
   { 0x2CBA, /* C, */ 0x2CBB }, // # COPTIC CAPITAL LETTER DIALECT - P NI
   { 0x2CBC, /* C, */ 0x2CBD }, // # COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
   { 0x2CBE, /* C, */ 0x2CBF }, // # COPTIC CAPITAL LETTER OLD COPTIC OOU
   { 0x2CC0, /* C, */ 0x2CC1 }, // # COPTIC CAPITAL LETTER SAMPI
   { 0x2CC2, /* C, */ 0x2CC3 }, // # COPTIC CAPITAL LETTER CROSSED SHEI
   { 0x2CC4, /* C, */ 0x2CC5 }, // # COPTIC CAPITAL LETTER OLD COPTIC SHEI
   { 0x2CC6, /* C, */ 0x2CC7 }, // # COPTIC CAPITAL LETTER OLD COPTIC ESH
   { 0x2CC8, /* C, */ 0x2CC9 }, // # COPTIC CAPITAL LETTER AKHMIMIC KHEI
   { 0x2CCA, /* C, */ 0x2CCB }, // # COPTIC CAPITAL LETTER DIALECT - P HORI
   { 0x2CCC, /* C, */ 0x2CCD }, // # COPTIC CAPITAL LETTER OLD COPTIC HORI
   { 0x2CCE, /* C, */ 0x2CCF }, // # COPTIC CAPITAL LETTER OLD COPTIC HA
   { 0x2CD0, /* C, */ 0x2CD1 }, // # COPTIC CAPITAL LETTER L - SHAPED HA
   { 0x2CD2, /* C, */ 0x2CD3 }, // # COPTIC CAPITAL LETTER OLD COPTIC HEI
   { 0x2CD4, /* C, */ 0x2CD5 }, // # COPTIC CAPITAL LETTER OLD COPTIC HAT
   { 0x2CD6, /* C, */ 0x2CD7 }, // # COPTIC CAPITAL LETTER OLD COPTIC GANGIA
   { 0x2CD8, /* C, */ 0x2CD9 }, // # COPTIC CAPITAL LETTER OLD COPTIC DJA
   { 0x2CDA, /* C, */ 0x2CDB }, // # COPTIC CAPITAL LETTER OLD COPTIC SHIMA
   { 0x2CDC, /* C, */ 0x2CDD }, // # COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
   { 0x2CDE, /* C, */ 0x2CDF }, // # COPTIC CAPITAL LETTER OLD NUBIAN NGI
   { 0x2CE0, /* C, */ 0x2CE1 }, // # COPTIC CAPITAL LETTER OLD NUBIAN NYI
   { 0x2CE2, /* C, */ 0x2CE3 }, // # COPTIC CAPITAL LETTER OLD NUBIAN WAU
   { 0x2CEB, /* C, */ 0x2CEC }, // # COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
   { 0x2CED, /* C, */ 0x2CEE }, // # COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
   { 0x2CF2, /* C, */ 0x2CF3 }, // # COPTIC CAPITAL LETTER BOHAIRIC KHEI
   { 0xA640, /* C, */ 0xA641 }, // # CYRILLIC CAPITAL LETTER ZEMLYA
   { 0xA642, /* C, */ 0xA643 }, // # CYRILLIC CAPITAL LETTER DZELO
   { 0xA644, /* C, */ 0xA645 }, // # CYRILLIC CAPITAL LETTER REVERSED DZE
   { 0xA646, /* C, */ 0xA647 }, // # CYRILLIC CAPITAL LETTER IOTA
   { 0xA648, /* C, */ 0xA649 }, // # CYRILLIC CAPITAL LETTER DJERV
   { 0xA64A, /* C, */ 0xA64B }, // # CYRILLIC CAPITAL LETTER MONOGRAPH UK
   { 0xA64C, /* C, */ 0xA64D }, // # CYRILLIC CAPITAL LETTER BROAD OMEGA
   { 0xA64E, /* C, */ 0xA64F }, // # CYRILLIC CAPITAL LETTER NEUTRAL YER
   { 0xA650, /* C, */ 0xA651 }, // # CYRILLIC CAPITAL LETTER YERU WITH BACK YER
   { 0xA652, /* C, */ 0xA653 }, // # CYRILLIC CAPITAL LETTER IOTIFIED YAT
   { 0xA654, /* C, */ 0xA655 }, // # CYRILLIC CAPITAL LETTER REVERSED YU
   { 0xA656, /* C, */ 0xA657 }, // # CYRILLIC CAPITAL LETTER IOTIFIED A
   { 0xA658, /* C, */ 0xA659 }, // # CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
   { 0xA65A, /* C, */ 0xA65B }, // # CYRILLIC CAPITAL LETTER BLENDED YUS
   { 0xA65C, /* C, */ 0xA65D }, // # CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
   { 0xA65E, /* C, */ 0xA65F }, // # CYRILLIC CAPITAL LETTER YN
   { 0xA660, /* C, */ 0xA661 }, // # CYRILLIC CAPITAL LETTER REVERSED TSE
   { 0xA662, /* C, */ 0xA663 }, // # CYRILLIC CAPITAL LETTER SOFT DE
   { 0xA664, /* C, */ 0xA665 }, // # CYRILLIC CAPITAL LETTER SOFT EL
   { 0xA666, /* C, */ 0xA667 }, // # CYRILLIC CAPITAL LETTER SOFT EM
   { 0xA668, /* C, */ 0xA669 }, // # CYRILLIC CAPITAL LETTER MONOCULAR O
   { 0xA66A, /* C, */ 0xA66B }, // # CYRILLIC CAPITAL LETTER BINOCULAR O
   { 0xA66C, /* C, */ 0xA66D }, // # CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
   { 0xA680, /* C, */ 0xA681 }, // # CYRILLIC CAPITAL LETTER DWE
   { 0xA682, /* C, */ 0xA683 }, // # CYRILLIC CAPITAL LETTER DZWE
   { 0xA684, /* C, */ 0xA685 }, // # CYRILLIC CAPITAL LETTER ZHWE
   { 0xA686, /* C, */ 0xA687 }, // # CYRILLIC CAPITAL LETTER CCHE
   { 0xA688, /* C, */ 0xA689 }, // # CYRILLIC CAPITAL LETTER DZZE
   { 0xA68A, /* C, */ 0xA68B }, // # CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
   { 0xA68C, /* C, */ 0xA68D }, // # CYRILLIC CAPITAL LETTER TWE
   { 0xA68E, /* C, */ 0xA68F }, // # CYRILLIC CAPITAL LETTER TSWE
   { 0xA690, /* C, */ 0xA691 }, // # CYRILLIC CAPITAL LETTER TSSE
   { 0xA692, /* C, */ 0xA693 }, // # CYRILLIC CAPITAL LETTER TCHE
   { 0xA694, /* C, */ 0xA695 }, // # CYRILLIC CAPITAL LETTER HWE
   { 0xA696, /* C, */ 0xA697 }, // # CYRILLIC CAPITAL LETTER SHWE
   { 0xA698, /* C, */ 0xA699 }, // # CYRILLIC CAPITAL LETTER DOUBLE O
   { 0xA69A, /* C, */ 0xA69B }, // # CYRILLIC CAPITAL LETTER CROSSED O
   { 0xA722, /* C, */ 0xA723 }, // # LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
   { 0xA724, /* C, */ 0xA725 }, // # LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
   { 0xA726, /* C, */ 0xA727 }, // # LATIN CAPITAL LETTER HENG
   { 0xA728, /* C, */ 0xA729 }, // # LATIN CAPITAL LETTER TZ
   { 0xA72A, /* C, */ 0xA72B }, // # LATIN CAPITAL LETTER TRESILLO
   { 0xA72C, /* C, */ 0xA72D }, // # LATIN CAPITAL LETTER CUATRILLO
   { 0xA72E, /* C, */ 0xA72F }, // # LATIN CAPITAL LETTER CUATRILLO WITH COMMA
   { 0xA732, /* C, */ 0xA733 }, // # LATIN CAPITAL LETTER AA
   { 0xA734, /* C, */ 0xA735 }, // # LATIN CAPITAL LETTER AO
   { 0xA736, /* C, */ 0xA737 }, // # LATIN CAPITAL LETTER AU
   { 0xA738, /* C, */ 0xA739 }, // # LATIN CAPITAL LETTER AV
   { 0xA73A, /* C, */ 0xA73B }, // # LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
   { 0xA73C, /* C, */ 0xA73D }, // # LATIN CAPITAL LETTER AY
   { 0xA73E, /* C, */ 0xA73F }, // # LATIN CAPITAL LETTER REVERSED C WITH DOT
   { 0xA740, /* C, */ 0xA741 }, // # LATIN CAPITAL LETTER K WITH STROKE
   { 0xA742, /* C, */ 0xA743 }, // # LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
   { 0xA744, /* C, */ 0xA745 }, // # LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
   { 0xA746, /* C, */ 0xA747 }, // # LATIN CAPITAL LETTER BROKEN L
   { 0xA748, /* C, */ 0xA749 }, // # LATIN CAPITAL LETTER L WITH HIGH STROKE
   { 0xA74A, /* C, */ 0xA74B }, // # LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
   { 0xA74C, /* C, */ 0xA74D }, // # LATIN CAPITAL LETTER O WITH LOOP
   { 0xA74E, /* C, */ 0xA74F }, // # LATIN CAPITAL LETTER OO
   { 0xA750, /* C, */ 0xA751 }, // # LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
   { 0xA752, /* C, */ 0xA753 }, // # LATIN CAPITAL LETTER P WITH FLOURISH
   { 0xA754, /* C, */ 0xA755 }, // # LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
   { 0xA756, /* C, */ 0xA757 }, // # LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
   { 0xA758, /* C, */ 0xA759 }, // # LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
   { 0xA75A, /* C, */ 0xA75B }, // # LATIN CAPITAL LETTER R ROTUNDA
   { 0xA75C, /* C, */ 0xA75D }, // # LATIN CAPITAL LETTER RUM ROTUNDA
   { 0xA75E, /* C, */ 0xA75F }, // # LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
   { 0xA760, /* C, */ 0xA761 }, // # LATIN CAPITAL LETTER VY
   { 0xA762, /* C, */ 0xA763 }, // # LATIN CAPITAL LETTER VISIGOTHIC Z
   { 0xA764, /* C, */ 0xA765 }, // # LATIN CAPITAL LETTER THORN WITH STROKE
   { 0xA766, /* C, */ 0xA767 }, // # LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
   { 0xA768, /* C, */ 0xA769 }, // # LATIN CAPITAL LETTER VEND
   { 0xA76A, /* C, */ 0xA76B }, // # LATIN CAPITAL LETTER ET
   { 0xA76C, /* C, */ 0xA76D }, // # LATIN CAPITAL LETTER IS
   { 0xA76E, /* C, */ 0xA76F }, // # LATIN CAPITAL LETTER CON
   { 0xA779, /* C, */ 0xA77A }, // # LATIN CAPITAL LETTER INSULAR D
   { 0xA77B, /* C, */ 0xA77C }, // # LATIN CAPITAL LETTER INSULAR F
   { 0xA77D, /* C, */ 0x1D79 }, // # LATIN CAPITAL LETTER INSULAR G
   { 0xA77E, /* C, */ 0xA77F }, // # LATIN CAPITAL LETTER TURNED INSULAR G
   { 0xA780, /* C, */ 0xA781 }, // # LATIN CAPITAL LETTER TURNED L
   { 0xA782, /* C, */ 0xA783 }, // # LATIN CAPITAL LETTER INSULAR R
   { 0xA784, /* C, */ 0xA785 }, // # LATIN CAPITAL LETTER INSULAR S
   { 0xA786, /* C, */ 0xA787 }, // # LATIN CAPITAL LETTER INSULAR T
   { 0xA78B, /* C, */ 0xA78C }, // # LATIN CAPITAL LETTER SALTILLO
   { 0xA78D, /* C, */ 0x0265 }, // # LATIN CAPITAL LETTER TURNED H
   { 0xA790, /* C, */ 0xA791 }, // # LATIN CAPITAL LETTER N WITH DESCENDER
   { 0xA792, /* C, */ 0xA793 }, // # LATIN CAPITAL LETTER C WITH BAR
   { 0xA796, /* C, */ 0xA797 }, // # LATIN CAPITAL LETTER B WITH FLOURISH
   { 0xA798, /* C, */ 0xA799 }, // # LATIN CAPITAL LETTER F WITH STROKE
   { 0xA79A, /* C, */ 0xA79B }, // # LATIN CAPITAL LETTER VOLAPUK AE
   { 0xA79C, /* C, */ 0xA79D }, // # LATIN CAPITAL LETTER VOLAPUK OE
   { 0xA79E, /* C, */ 0xA79F }, // # LATIN CAPITAL LETTER VOLAPUK UE
   { 0xA7A0, /* C, */ 0xA7A1 }, // # LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
   { 0xA7A2, /* C, */ 0xA7A3 }, // # LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
   { 0xA7A4, /* C, */ 0xA7A5 }, // # LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
   { 0xA7A6, /* C, */ 0xA7A7 }, // # LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
   { 0xA7A8, /* C, */ 0xA7A9 }, // # LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
   { 0xA7AA, /* C, */ 0x0266 }, // # LATIN CAPITAL LETTER H WITH HOOK
   { 0xA7AB, /* C, */ 0x025C }, // # LATIN CAPITAL LETTER REVERSED OPEN E
   { 0xA7AC, /* C, */ 0x0261 }, // # LATIN CAPITAL LETTER SCRIPT G
   { 0xA7AD, /* C, */ 0x026C }, // # LATIN CAPITAL LETTER L WITH BELT
   { 0xA7AE, /* C, */ 0x026A }, // # LATIN CAPITAL LETTER SMALL CAPITAL I
   { 0xA7B0, /* C, */ 0x029E }, // # LATIN CAPITAL LETTER TURNED K
   { 0xA7B1, /* C, */ 0x0287 }, // # LATIN CAPITAL LETTER TURNED T
   { 0xA7B2, /* C, */ 0x029D }, // # LATIN CAPITAL LETTER J WITH CROSSED - TAIL
   { 0xA7B3, /* C, */ 0xAB53 }, // # LATIN CAPITAL LETTER CHI
   { 0xA7B4, /* C, */ 0xA7B5 }, // # LATIN CAPITAL LETTER BETA
   { 0xA7B6, /* C, */ 0xA7B7 }, // # LATIN CAPITAL LETTER OMEGA
   { 0xA7B8, /* C, */ 0xA7B9 }, // # LATIN CAPITAL LETTER U WITH STROKE
   { 0xA7BA, /* C, */ 0xA7BB }, // # LATIN CAPITAL LETTER GLOTTAL A
   { 0xA7BC, /* C, */ 0xA7BD }, // # LATIN CAPITAL LETTER GLOTTAL I
   { 0xA7BE, /* C, */ 0xA7BF }, // # LATIN CAPITAL LETTER GLOTTAL U
   { 0xA7C2, /* C, */ 0xA7C3 }, // # LATIN CAPITAL LETTER ANGLICANA W
   { 0xA7C4, /* C, */ 0xA794 }, // # LATIN CAPITAL LETTER C WITH PALATAL HOOK
   { 0xA7C5, /* C, */ 0x0282 }, // # LATIN CAPITAL LETTER S WITH HOOK
   { 0xA7C6, /* C, */ 0x1D8E }, // # LATIN CAPITAL LETTER Z WITH PALATAL HOOK
   { 0xAB70, /* C, */ 0x13A0 }, // # CHEROKEE SMALL LETTER A
   { 0xAB71, /* C, */ 0x13A1 }, // # CHEROKEE SMALL LETTER E
   { 0xAB72, /* C, */ 0x13A2 }, // # CHEROKEE SMALL LETTER I
   { 0xAB73, /* C, */ 0x13A3 }, // # CHEROKEE SMALL LETTER O
   { 0xAB74, /* C, */ 0x13A4 }, // # CHEROKEE SMALL LETTER U
   { 0xAB75, /* C, */ 0x13A5 }, // # CHEROKEE SMALL LETTER V
   { 0xAB76, /* C, */ 0x13A6 }, // # CHEROKEE SMALL LETTER GA
   { 0xAB77, /* C, */ 0x13A7 }, // # CHEROKEE SMALL LETTER KA
   { 0xAB78, /* C, */ 0x13A8 }, // # CHEROKEE SMALL LETTER GE
   { 0xAB79, /* C, */ 0x13A9 }, // # CHEROKEE SMALL LETTER GI
   { 0xAB7A, /* C, */ 0x13AA }, // # CHEROKEE SMALL LETTER GO
   { 0xAB7B, /* C, */ 0x13AB }, // # CHEROKEE SMALL LETTER GU
   { 0xAB7C, /* C, */ 0x13AC }, // # CHEROKEE SMALL LETTER GV
   { 0xAB7D, /* C, */ 0x13AD }, // # CHEROKEE SMALL LETTER HA
   { 0xAB7E, /* C, */ 0x13AE }, // # CHEROKEE SMALL LETTER HE
   { 0xAB7F, /* C, */ 0x13AF }, // # CHEROKEE SMALL LETTER HI
   { 0xAB80, /* C, */ 0x13B0 }, // # CHEROKEE SMALL LETTER HO
   { 0xAB81, /* C, */ 0x13B1 }, // # CHEROKEE SMALL LETTER HU
   { 0xAB82, /* C, */ 0x13B2 }, // # CHEROKEE SMALL LETTER HV
   { 0xAB83, /* C, */ 0x13B3 }, // # CHEROKEE SMALL LETTER LA
   { 0xAB84, /* C, */ 0x13B4 }, // # CHEROKEE SMALL LETTER LE
   { 0xAB85, /* C, */ 0x13B5 }, // # CHEROKEE SMALL LETTER LI
   { 0xAB86, /* C, */ 0x13B6 }, // # CHEROKEE SMALL LETTER LO
   { 0xAB87, /* C, */ 0x13B7 }, // # CHEROKEE SMALL LETTER LU
   { 0xAB88, /* C, */ 0x13B8 }, // # CHEROKEE SMALL LETTER LV
   { 0xAB89, /* C, */ 0x13B9 }, // # CHEROKEE SMALL LETTER MA
   { 0xAB8A, /* C, */ 0x13BA }, // # CHEROKEE SMALL LETTER ME
   { 0xAB8B, /* C, */ 0x13BB }, // # CHEROKEE SMALL LETTER MI
   { 0xAB8C, /* C, */ 0x13BC }, // # CHEROKEE SMALL LETTER MO
   { 0xAB8D, /* C, */ 0x13BD }, // # CHEROKEE SMALL LETTER MU
   { 0xAB8E, /* C, */ 0x13BE }, // # CHEROKEE SMALL LETTER NA
   { 0xAB8F, /* C, */ 0x13BF }, // # CHEROKEE SMALL LETTER HNA
   { 0xAB90, /* C, */ 0x13C0 }, // # CHEROKEE SMALL LETTER NAH
   { 0xAB91, /* C, */ 0x13C1 }, // # CHEROKEE SMALL LETTER NE
   { 0xAB92, /* C, */ 0x13C2 }, // # CHEROKEE SMALL LETTER NI
   { 0xAB93, /* C, */ 0x13C3 }, // # CHEROKEE SMALL LETTER NO
   { 0xAB94, /* C, */ 0x13C4 }, // # CHEROKEE SMALL LETTER NU
   { 0xAB95, /* C, */ 0x13C5 }, // # CHEROKEE SMALL LETTER NV
   { 0xAB96, /* C, */ 0x13C6 }, // # CHEROKEE SMALL LETTER QUA
   { 0xAB97, /* C, */ 0x13C7 }, // # CHEROKEE SMALL LETTER QUE
   { 0xAB98, /* C, */ 0x13C8 }, // # CHEROKEE SMALL LETTER QUI
   { 0xAB99, /* C, */ 0x13C9 }, // # CHEROKEE SMALL LETTER QUO
   { 0xAB9A, /* C, */ 0x13CA }, // # CHEROKEE SMALL LETTER QUU
   { 0xAB9B, /* C, */ 0x13CB }, // # CHEROKEE SMALL LETTER QUV
   { 0xAB9C, /* C, */ 0x13CC }, // # CHEROKEE SMALL LETTER SA
   { 0xAB9D, /* C, */ 0x13CD }, // # CHEROKEE SMALL LETTER S
   { 0xAB9E, /* C, */ 0x13CE }, // # CHEROKEE SMALL LETTER SE
   { 0xAB9F, /* C, */ 0x13CF }, // # CHEROKEE SMALL LETTER SI
   { 0xABA0, /* C, */ 0x13D0 }, // # CHEROKEE SMALL LETTER SO
   { 0xABA1, /* C, */ 0x13D1 }, // # CHEROKEE SMALL LETTER SU
   { 0xABA2, /* C, */ 0x13D2 }, // # CHEROKEE SMALL LETTER SV
   { 0xABA3, /* C, */ 0x13D3 }, // # CHEROKEE SMALL LETTER DA
   { 0xABA4, /* C, */ 0x13D4 }, // # CHEROKEE SMALL LETTER TA
   { 0xABA5, /* C, */ 0x13D5 }, // # CHEROKEE SMALL LETTER DE
   { 0xABA6, /* C, */ 0x13D6 }, // # CHEROKEE SMALL LETTER TE
   { 0xABA7, /* C, */ 0x13D7 }, // # CHEROKEE SMALL LETTER DI
   { 0xABA8, /* C, */ 0x13D8 }, // # CHEROKEE SMALL LETTER TI
   { 0xABA9, /* C, */ 0x13D9 }, // # CHEROKEE SMALL LETTER DO
   { 0xABAA, /* C, */ 0x13DA }, // # CHEROKEE SMALL LETTER DU
   { 0xABAB, /* C, */ 0x13DB }, // # CHEROKEE SMALL LETTER DV
   { 0xABAC, /* C, */ 0x13DC }, // # CHEROKEE SMALL LETTER DLA
   { 0xABAD, /* C, */ 0x13DD }, // # CHEROKEE SMALL LETTER TLA
   { 0xABAE, /* C, */ 0x13DE }, // # CHEROKEE SMALL LETTER TLE
   { 0xABAF, /* C, */ 0x13DF }, // # CHEROKEE SMALL LETTER TLI
   { 0xABB0, /* C, */ 0x13E0 }, // # CHEROKEE SMALL LETTER TLO
   { 0xABB1, /* C, */ 0x13E1 }, // # CHEROKEE SMALL LETTER TLU
   { 0xABB2, /* C, */ 0x13E2 }, // # CHEROKEE SMALL LETTER TLV
   { 0xABB3, /* C, */ 0x13E3 }, // # CHEROKEE SMALL LETTER TSA
   { 0xABB4, /* C, */ 0x13E4 }, // # CHEROKEE SMALL LETTER TSE
   { 0xABB5, /* C, */ 0x13E5 }, // # CHEROKEE SMALL LETTER TSI
   { 0xABB6, /* C, */ 0x13E6 }, // # CHEROKEE SMALL LETTER TSO
   { 0xABB7, /* C, */ 0x13E7 }, // # CHEROKEE SMALL LETTER TSU
   { 0xABB8, /* C, */ 0x13E8 }, // # CHEROKEE SMALL LETTER TSV
   { 0xABB9, /* C, */ 0x13E9 }, // # CHEROKEE SMALL LETTER WA
   { 0xABBA, /* C, */ 0x13EA }, // # CHEROKEE SMALL LETTER WE
   { 0xABBB, /* C, */ 0x13EB }, // # CHEROKEE SMALL LETTER WI
   { 0xABBC, /* C, */ 0x13EC }, // # CHEROKEE SMALL LETTER WO
   { 0xABBD, /* C, */ 0x13ED }, // # CHEROKEE SMALL LETTER WU
   { 0xABBE, /* C, */ 0x13EE }, // # CHEROKEE SMALL LETTER WV
   { 0xABBF, /* C, */ 0x13EF }, // # CHEROKEE SMALL LETTER YA
   { 0xFF21, /* C, */ 0xFF41 }, // # FULLWIDTH LATIN CAPITAL LETTER A
   { 0xFF22, /* C, */ 0xFF42 }, // # FULLWIDTH LATIN CAPITAL LETTER B
   { 0xFF23, /* C, */ 0xFF43 }, // # FULLWIDTH LATIN CAPITAL LETTER C
   { 0xFF24, /* C, */ 0xFF44 }, // # FULLWIDTH LATIN CAPITAL LETTER D
   { 0xFF25, /* C, */ 0xFF45 }, // # FULLWIDTH LATIN CAPITAL LETTER E
   { 0xFF26, /* C, */ 0xFF46 }, // # FULLWIDTH LATIN CAPITAL LETTER F
   { 0xFF27, /* C, */ 0xFF47 }, // # FULLWIDTH LATIN CAPITAL LETTER G
   { 0xFF28, /* C, */ 0xFF48 }, // # FULLWIDTH LATIN CAPITAL LETTER H
   { 0xFF29, /* C, */ 0xFF49 }, // # FULLWIDTH LATIN CAPITAL LETTER I
   { 0xFF2A, /* C, */ 0xFF4A }, // # FULLWIDTH LATIN CAPITAL LETTER J
   { 0xFF2B, /* C, */ 0xFF4B }, // # FULLWIDTH LATIN CAPITAL LETTER K
   { 0xFF2C, /* C, */ 0xFF4C }, // # FULLWIDTH LATIN CAPITAL LETTER L
   { 0xFF2D, /* C, */ 0xFF4D }, // # FULLWIDTH LATIN CAPITAL LETTER M
   { 0xFF2E, /* C, */ 0xFF4E }, // # FULLWIDTH LATIN CAPITAL LETTER N
   { 0xFF2F, /* C, */ 0xFF4F }, // # FULLWIDTH LATIN CAPITAL LETTER O
   { 0xFF30, /* C, */ 0xFF50 }, // # FULLWIDTH LATIN CAPITAL LETTER P
   { 0xFF31, /* C, */ 0xFF51 }, // # FULLWIDTH LATIN CAPITAL LETTER Q
   { 0xFF32, /* C, */ 0xFF52 }, // # FULLWIDTH LATIN CAPITAL LETTER R
   { 0xFF33, /* C, */ 0xFF53 }, // # FULLWIDTH LATIN CAPITAL LETTER S
   { 0xFF34, /* C, */ 0xFF54 }, // # FULLWIDTH LATIN CAPITAL LETTER T
   { 0xFF35, /* C, */ 0xFF55 }, // # FULLWIDTH LATIN CAPITAL LETTER U
   { 0xFF36, /* C, */ 0xFF56 }, // # FULLWIDTH LATIN CAPITAL LETTER V
   { 0xFF37, /* C, */ 0xFF57 }, // # FULLWIDTH LATIN CAPITAL LETTER W
   { 0xFF38, /* C, */ 0xFF58 }, // # FULLWIDTH LATIN CAPITAL LETTER X
   { 0xFF39, /* C, */ 0xFF59 }, // # FULLWIDTH LATIN CAPITAL LETTER Y
   { 0xFF3A, /* C, */ 0xFF5A }, // # FULLWIDTH LATIN CAPITAL LETTER Z
   { 0x10400, /* C, */ 0x10428 }, // # DESERET CAPITAL LETTER LONG I
   { 0x10401, /* C, */ 0x10429 }, // # DESERET CAPITAL LETTER LONG E
   { 0x10402, /* C, */ 0x1042A }, // # DESERET CAPITAL LETTER LONG A
   { 0x10403, /* C, */ 0x1042B }, // # DESERET CAPITAL LETTER LONG AH
   { 0x10404, /* C, */ 0x1042C }, // # DESERET CAPITAL LETTER LONG O
   { 0x10405, /* C, */ 0x1042D }, // # DESERET CAPITAL LETTER LONG OO
   { 0x10406, /* C, */ 0x1042E }, // # DESERET CAPITAL LETTER SHORT I
   { 0x10407, /* C, */ 0x1042F }, // # DESERET CAPITAL LETTER SHORT E
   { 0x10408, /* C, */ 0x10430 }, // # DESERET CAPITAL LETTER SHORT A
   { 0x10409, /* C, */ 0x10431 }, // # DESERET CAPITAL LETTER SHORT AH
   { 0x1040A, /* C, */ 0x10432 }, // # DESERET CAPITAL LETTER SHORT O
   { 0x1040B, /* C, */ 0x10433 }, // # DESERET CAPITAL LETTER SHORT OO
   { 0x1040C, /* C, */ 0x10434 }, // # DESERET CAPITAL LETTER AY
   { 0x1040D, /* C, */ 0x10435 }, // # DESERET CAPITAL LETTER OW
   { 0x1040E, /* C, */ 0x10436 }, // # DESERET CAPITAL LETTER WU
   { 0x1040F, /* C, */ 0x10437 }, // # DESERET CAPITAL LETTER YEE
   { 0x10410, /* C, */ 0x10438 }, // # DESERET CAPITAL LETTER H
   { 0x10411, /* C, */ 0x10439 }, // # DESERET CAPITAL LETTER PEE
   { 0x10412, /* C, */ 0x1043A }, // # DESERET CAPITAL LETTER BEE
   { 0x10413, /* C, */ 0x1043B }, // # DESERET CAPITAL LETTER TEE
   { 0x10414, /* C, */ 0x1043C }, // # DESERET CAPITAL LETTER DEE
   { 0x10415, /* C, */ 0x1043D }, // # DESERET CAPITAL LETTER CHEE
   { 0x10416, /* C, */ 0x1043E }, // # DESERET CAPITAL LETTER JEE
   { 0x10417, /* C, */ 0x1043F }, // # DESERET CAPITAL LETTER KAY
   { 0x10418, /* C, */ 0x10440 }, // # DESERET CAPITAL LETTER GAY
   { 0x10419, /* C, */ 0x10441 }, // # DESERET CAPITAL LETTER EF
   { 0x1041A, /* C, */ 0x10442 }, // # DESERET CAPITAL LETTER VEE
   { 0x1041B, /* C, */ 0x10443 }, // # DESERET CAPITAL LETTER ETH
   { 0x1041C, /* C, */ 0x10444 }, // # DESERET CAPITAL LETTER THEE
   { 0x1041D, /* C, */ 0x10445 }, // # DESERET CAPITAL LETTER ES
   { 0x1041E, /* C, */ 0x10446 }, // # DESERET CAPITAL LETTER ZEE
   { 0x1041F, /* C, */ 0x10447 }, // # DESERET CAPITAL LETTER ESH
   { 0x10420, /* C, */ 0x10448 }, // # DESERET CAPITAL LETTER ZHEE
   { 0x10421, /* C, */ 0x10449 }, // # DESERET CAPITAL LETTER ER
   { 0x10422, /* C, */ 0x1044A }, // # DESERET CAPITAL LETTER EL
   { 0x10423, /* C, */ 0x1044B }, // # DESERET CAPITAL LETTER EM
   { 0x10424, /* C, */ 0x1044C }, // # DESERET CAPITAL LETTER EN
   { 0x10425, /* C, */ 0x1044D }, // # DESERET CAPITAL LETTER ENG
   { 0x10426, /* C, */ 0x1044E }, // # DESERET CAPITAL LETTER OI
   { 0x10427, /* C, */ 0x1044F }, // # DESERET CAPITAL LETTER EW
   { 0x104B0, /* C, */ 0x104D8 }, // # OSAGE CAPITAL LETTER A
   { 0x104B1, /* C, */ 0x104D9 }, // # OSAGE CAPITAL LETTER AI
   { 0x104B2, /* C, */ 0x104DA }, // # OSAGE CAPITAL LETTER AIN
   { 0x104B3, /* C, */ 0x104DB }, // # OSAGE CAPITAL LETTER AH
   { 0x104B4, /* C, */ 0x104DC }, // # OSAGE CAPITAL LETTER BRA
   { 0x104B5, /* C, */ 0x104DD }, // # OSAGE CAPITAL LETTER CHA
   { 0x104B6, /* C, */ 0x104DE }, // # OSAGE CAPITAL LETTER EHCHA
   { 0x104B7, /* C, */ 0x104DF }, // # OSAGE CAPITAL LETTER E
   { 0x104B8, /* C, */ 0x104E0 }, // # OSAGE CAPITAL LETTER EIN
   { 0x104B9, /* C, */ 0x104E1 }, // # OSAGE CAPITAL LETTER HA
   { 0x104BA, /* C, */ 0x104E2 }, // # OSAGE CAPITAL LETTER HYA
   { 0x104BB, /* C, */ 0x104E3 }, // # OSAGE CAPITAL LETTER I
   { 0x104BC, /* C, */ 0x104E4 }, // # OSAGE CAPITAL LETTER KA
   { 0x104BD, /* C, */ 0x104E5 }, // # OSAGE CAPITAL LETTER EHKA
   { 0x104BE, /* C, */ 0x104E6 }, // # OSAGE CAPITAL LETTER KYA
   { 0x104BF, /* C, */ 0x104E7 }, // # OSAGE CAPITAL LETTER LA
   { 0x104C0, /* C, */ 0x104E8 }, // # OSAGE CAPITAL LETTER MA
   { 0x104C1, /* C, */ 0x104E9 }, // # OSAGE CAPITAL LETTER NA
   { 0x104C2, /* C, */ 0x104EA }, // # OSAGE CAPITAL LETTER O
   { 0x104C3, /* C, */ 0x104EB }, // # OSAGE CAPITAL LETTER OIN
   { 0x104C4, /* C, */ 0x104EC }, // # OSAGE CAPITAL LETTER PA
   { 0x104C5, /* C, */ 0x104ED }, // # OSAGE CAPITAL LETTER EHPA
   { 0x104C6, /* C, */ 0x104EE }, // # OSAGE CAPITAL LETTER SA
   { 0x104C7, /* C, */ 0x104EF }, // # OSAGE CAPITAL LETTER SHA
   { 0x104C8, /* C, */ 0x104F0 }, // # OSAGE CAPITAL LETTER TA
   { 0x104C9, /* C, */ 0x104F1 }, // # OSAGE CAPITAL LETTER EHTA
   { 0x104CA, /* C, */ 0x104F2 }, // # OSAGE CAPITAL LETTER TSA
   { 0x104CB, /* C, */ 0x104F3 }, // # OSAGE CAPITAL LETTER EHTSA
   { 0x104CC, /* C, */ 0x104F4 }, // # OSAGE CAPITAL LETTER TSHA
   { 0x104CD, /* C, */ 0x104F5 }, // # OSAGE CAPITAL LETTER DHA
   { 0x104CE, /* C, */ 0x104F6 }, // # OSAGE CAPITAL LETTER U
   { 0x104CF, /* C, */ 0x104F7 }, // # OSAGE CAPITAL LETTER WA
   { 0x104D0, /* C, */ 0x104F8 }, // # OSAGE CAPITAL LETTER KHA
   { 0x104D1, /* C, */ 0x104F9 }, // # OSAGE CAPITAL LETTER GHA
   { 0x104D2, /* C, */ 0x104FA }, // # OSAGE CAPITAL LETTER ZA
   { 0x104D3, /* C, */ 0x104FB }, // # OSAGE CAPITAL LETTER ZHA
   { 0x10C80, /* C, */ 0x10CC0 }, // # OLD HUNGARIAN CAPITAL LETTER A
   { 0x10C81, /* C, */ 0x10CC1 }, // # OLD HUNGARIAN CAPITAL LETTER AA
   { 0x10C82, /* C, */ 0x10CC2 }, // # OLD HUNGARIAN CAPITAL LETTER EB
   { 0x10C83, /* C, */ 0x10CC3 }, // # OLD HUNGARIAN CAPITAL LETTER AMB
   { 0x10C84, /* C, */ 0x10CC4 }, // # OLD HUNGARIAN CAPITAL LETTER EC
   { 0x10C85, /* C, */ 0x10CC5 }, // # OLD HUNGARIAN CAPITAL LETTER ENC
   { 0x10C86, /* C, */ 0x10CC6 }, // # OLD HUNGARIAN CAPITAL LETTER ECS
   { 0x10C87, /* C, */ 0x10CC7 }, // # OLD HUNGARIAN CAPITAL LETTER ED
   { 0x10C88, /* C, */ 0x10CC8 }, // # OLD HUNGARIAN CAPITAL LETTER AND
   { 0x10C89, /* C, */ 0x10CC9 }, // # OLD HUNGARIAN CAPITAL LETTER E
   { 0x10C8A, /* C, */ 0x10CCA }, // # OLD HUNGARIAN CAPITAL LETTER CLOSE E
   { 0x10C8B, /* C, */ 0x10CCB }, // # OLD HUNGARIAN CAPITAL LETTER EE
   { 0x10C8C, /* C, */ 0x10CCC }, // # OLD HUNGARIAN CAPITAL LETTER EF
   { 0x10C8D, /* C, */ 0x10CCD }, // # OLD HUNGARIAN CAPITAL LETTER EG
   { 0x10C8E, /* C, */ 0x10CCE }, // # OLD HUNGARIAN CAPITAL LETTER EGY
   { 0x10C8F, /* C, */ 0x10CCF }, // # OLD HUNGARIAN CAPITAL LETTER EH
   { 0x10C90, /* C, */ 0x10CD0 }, // # OLD HUNGARIAN CAPITAL LETTER I
   { 0x10C91, /* C, */ 0x10CD1 }, // # OLD HUNGARIAN CAPITAL LETTER II
   { 0x10C92, /* C, */ 0x10CD2 }, // # OLD HUNGARIAN CAPITAL LETTER EJ
   { 0x10C93, /* C, */ 0x10CD3 }, // # OLD HUNGARIAN CAPITAL LETTER EK
   { 0x10C94, /* C, */ 0x10CD4 }, // # OLD HUNGARIAN CAPITAL LETTER AK
   { 0x10C95, /* C, */ 0x10CD5 }, // # OLD HUNGARIAN CAPITAL LETTER UNK
   { 0x10C96, /* C, */ 0x10CD6 }, // # OLD HUNGARIAN CAPITAL LETTER EL
   { 0x10C97, /* C, */ 0x10CD7 }, // # OLD HUNGARIAN CAPITAL LETTER ELY
   { 0x10C98, /* C, */ 0x10CD8 }, // # OLD HUNGARIAN CAPITAL LETTER EM
   { 0x10C99, /* C, */ 0x10CD9 }, // # OLD HUNGARIAN CAPITAL LETTER EN
   { 0x10C9A, /* C, */ 0x10CDA }, // # OLD HUNGARIAN CAPITAL LETTER ENY
   { 0x10C9B, /* C, */ 0x10CDB }, // # OLD HUNGARIAN CAPITAL LETTER O
   { 0x10C9C, /* C, */ 0x10CDC }, // # OLD HUNGARIAN CAPITAL LETTER OO
   { 0x10C9D, /* C, */ 0x10CDD }, // # OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OE
   { 0x10C9E, /* C, */ 0x10CDE }, // # OLD HUNGARIAN CAPITAL LETTER RUDIMENTA OE
   { 0x10C9F, /* C, */ 0x10CDF }, // # OLD HUNGARIAN CAPITAL LETTER OEE
   { 0x10CA0, /* C, */ 0x10CE0 }, // # OLD HUNGARIAN CAPITAL LETTER EP
   { 0x10CA1, /* C, */ 0x10CE1 }, // # OLD HUNGARIAN CAPITAL LETTER EMP
   { 0x10CA2, /* C, */ 0x10CE2 }, // # OLD HUNGARIAN CAPITAL LETTER ER
   { 0x10CA3, /* C, */ 0x10CE3 }, // # OLD HUNGARIAN CAPITAL LETTER SHORT ER
   { 0x10CA4, /* C, */ 0x10CE4 }, // # OLD HUNGARIAN CAPITAL LETTER ES
   { 0x10CA5, /* C, */ 0x10CE5 }, // # OLD HUNGARIAN CAPITAL LETTER ESZ
   { 0x10CA6, /* C, */ 0x10CE6 }, // # OLD HUNGARIAN CAPITAL LETTER ET
   { 0x10CA7, /* C, */ 0x10CE7 }, // # OLD HUNGARIAN CAPITAL LETTER ENT
   { 0x10CA8, /* C, */ 0x10CE8 }, // # OLD HUNGARIAN CAPITAL LETTER ETY
   { 0x10CA9, /* C, */ 0x10CE9 }, // # OLD HUNGARIAN CAPITAL LETTER ECH
   { 0x10CAA, /* C, */ 0x10CEA }, // # OLD HUNGARIAN CAPITAL LETTER U
   { 0x10CAB, /* C, */ 0x10CEB }, // # OLD HUNGARIAN CAPITAL LETTER UU
   { 0x10CAC, /* C, */ 0x10CEC }, // # OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UE
   { 0x10CAD, /* C, */ 0x10CED }, // # OLD HUNGARIAN CAPITAL LETTER RUDIMENTA UE
   { 0x10CAE, /* C, */ 0x10CEE }, // # OLD HUNGARIAN CAPITAL LETTER EV
   { 0x10CAF, /* C, */ 0x10CEF }, // # OLD HUNGARIAN CAPITAL LETTER EZ
   { 0x10CB0, /* C, */ 0x10CF0 }, // # OLD HUNGARIAN CAPITAL LETTER EZS
   { 0x10CB1, /* C, */ 0x10CF1 }, // # OLD HUNGARIAN CAPITAL LETTER ENT - SHAPED SIGN
   { 0x10CB2, /* C, */ 0x10CF2 }, // # OLD HUNGARIAN CAPITAL LETTER US
   { 0x118A0, /* C, */ 0x118C0 }, // # WARANG CITI CAPITAL LETTER NGAA
   { 0x118A1, /* C, */ 0x118C1 }, // # WARANG CITI CAPITAL LETTER A
   { 0x118A2, /* C, */ 0x118C2 }, // # WARANG CITI CAPITAL LETTER WI
   { 0x118A3, /* C, */ 0x118C3 }, // # WARANG CITI CAPITAL LETTER YU
   { 0x118A4, /* C, */ 0x118C4 }, // # WARANG CITI CAPITAL LETTER YA
   { 0x118A5, /* C, */ 0x118C5 }, // # WARANG CITI CAPITAL LETTER YO
   { 0x118A6, /* C, */ 0x118C6 }, // # WARANG CITI CAPITAL LETTER II
   { 0x118A7, /* C, */ 0x118C7 }, // # WARANG CITI CAPITAL LETTER UU
   { 0x118A8, /* C, */ 0x118C8 }, // # WARANG CITI CAPITAL LETTER E
   { 0x118A9, /* C, */ 0x118C9 }, // # WARANG CITI CAPITAL LETTER O
   { 0x118AA, /* C, */ 0x118CA }, // # WARANG CITI CAPITAL LETTER ANG
   { 0x118AB, /* C, */ 0x118CB }, // # WARANG CITI CAPITAL LETTER GA
   { 0x118AC, /* C, */ 0x118CC }, // # WARANG CITI CAPITAL LETTER KO
   { 0x118AD, /* C, */ 0x118CD }, // # WARANG CITI CAPITAL LETTER ENY
   { 0x118AE, /* C, */ 0x118CE }, // # WARANG CITI CAPITAL LETTER YUJ
   { 0x118AF, /* C, */ 0x118CF }, // # WARANG CITI CAPITAL LETTER UC
   { 0x118B0, /* C, */ 0x118D0 }, // # WARANG CITI CAPITAL LETTER ENN
   { 0x118B1, /* C, */ 0x118D1 }, // # WARANG CITI CAPITAL LETTER ODD
   { 0x118B2, /* C, */ 0x118D2 }, // # WARANG CITI CAPITAL LETTER TTE
   { 0x118B3, /* C, */ 0x118D3 }, // # WARANG CITI CAPITAL LETTER NUNG
   { 0x118B4, /* C, */ 0x118D4 }, // # WARANG CITI CAPITAL LETTER DA
   { 0x118B5, /* C, */ 0x118D5 }, // # WARANG CITI CAPITAL LETTER AT
   { 0x118B6, /* C, */ 0x118D6 }, // # WARANG CITI CAPITAL LETTER AM
   { 0x118B7, /* C, */ 0x118D7 }, // # WARANG CITI CAPITAL LETTER BU
   { 0x118B8, /* C, */ 0x118D8 }, // # WARANG CITI CAPITAL LETTER PU
   { 0x118B9, /* C, */ 0x118D9 }, // # WARANG CITI CAPITAL LETTER HIYO
   { 0x118BA, /* C, */ 0x118DA }, // # WARANG CITI CAPITAL LETTER HOLO
   { 0x118BB, /* C, */ 0x118DB }, // # WARANG CITI CAPITAL LETTER HORR
   { 0x118BC, /* C, */ 0x118DC }, // # WARANG CITI CAPITAL LETTER HAR
   { 0x118BD, /* C, */ 0x118DD }, // # WARANG CITI CAPITAL LETTER SSUU
   { 0x118BE, /* C, */ 0x118DE }, // # WARANG CITI CAPITAL LETTER SII
   { 0x118BF, /* C, */ 0x118DF }, // # WARANG CITI CAPITAL LETTER VIYO
   { 0x16E40, /* C, */ 0x16E60 }, // # MEDEFAIDRIN CAPITAL LETTER M
   { 0x16E41, /* C, */ 0x16E61 }, // # MEDEFAIDRIN CAPITAL LETTER S
   { 0x16E42, /* C, */ 0x16E62 }, // # MEDEFAIDRIN CAPITAL LETTER V
   { 0x16E43, /* C, */ 0x16E63 }, // # MEDEFAIDRIN CAPITAL LETTER W
   { 0x16E44, /* C, */ 0x16E64 }, // # MEDEFAIDRIN CAPITAL LETTER ATIU
   { 0x16E45, /* C, */ 0x16E65 }, // # MEDEFAIDRIN CAPITAL LETTER Z
   { 0x16E46, /* C, */ 0x16E66 }, // # MEDEFAIDRIN CAPITAL LETTER KP
   { 0x16E47, /* C, */ 0x16E67 }, // # MEDEFAIDRIN CAPITAL LETTER P
   { 0x16E48, /* C, */ 0x16E68 }, // # MEDEFAIDRIN CAPITAL LETTER T
   { 0x16E49, /* C, */ 0x16E69 }, // # MEDEFAIDRIN CAPITAL LETTER G
   { 0x16E4A, /* C, */ 0x16E6A }, // # MEDEFAIDRIN CAPITAL LETTER F
   { 0x16E4B, /* C, */ 0x16E6B }, // # MEDEFAIDRIN CAPITAL LETTER I
   { 0x16E4C, /* C, */ 0x16E6C }, // # MEDEFAIDRIN CAPITAL LETTER K
   { 0x16E4D, /* C, */ 0x16E6D }, // # MEDEFAIDRIN CAPITAL LETTER A
   { 0x16E4E, /* C, */ 0x16E6E }, // # MEDEFAIDRIN CAPITAL LETTER J
   { 0x16E4F, /* C, */ 0x16E6F }, // # MEDEFAIDRIN CAPITAL LETTER E
   { 0x16E50, /* C, */ 0x16E70 }, // # MEDEFAIDRIN CAPITAL LETTER B
   { 0x16E51, /* C, */ 0x16E71 }, // # MEDEFAIDRIN CAPITAL LETTER C
   { 0x16E52, /* C, */ 0x16E72 }, // # MEDEFAIDRIN CAPITAL LETTER U
   { 0x16E53, /* C, */ 0x16E73 }, // # MEDEFAIDRIN CAPITAL LETTER YU
   { 0x16E54, /* C, */ 0x16E74 }, // # MEDEFAIDRIN CAPITAL LETTER L
   { 0x16E55, /* C, */ 0x16E75 }, // # MEDEFAIDRIN CAPITAL LETTER Q
   { 0x16E56, /* C, */ 0x16E76 }, // # MEDEFAIDRIN CAPITAL LETTER HP
   { 0x16E57, /* C, */ 0x16E77 }, // # MEDEFAIDRIN CAPITAL LETTER NY
   { 0x16E58, /* C, */ 0x16E78 }, // # MEDEFAIDRIN CAPITAL LETTER X
   { 0x16E59, /* C, */ 0x16E79 }, // # MEDEFAIDRIN CAPITAL LETTER D
   { 0x16E5A, /* C, */ 0x16E7A }, // # MEDEFAIDRIN CAPITAL LETTER OE
   { 0x16E5B, /* C, */ 0x16E7B }, // # MEDEFAIDRIN CAPITAL LETTER N
   { 0x16E5C, /* C, */ 0x16E7C }, // # MEDEFAIDRIN CAPITAL LETTER R
   { 0x16E5D, /* C, */ 0x16E7D }, // # MEDEFAIDRIN CAPITAL LETTER O
   { 0x16E5E, /* C, */ 0x16E7E }, // # MEDEFAIDRIN CAPITAL LETTER AI
   { 0x16E5F, /* C, */ 0x16E7F }, // # MEDEFAIDRIN CAPITAL LETTER Y
   { 0x1E900, /* C, */ 0x1E922 }, // # ADLAM CAPITAL LETTER ALIF
   { 0x1E901, /* C, */ 0x1E923 }, // # ADLAM CAPITAL LETTER DAALI
   { 0x1E902, /* C, */ 0x1E924 }, // # ADLAM CAPITAL LETTER LAAM
   { 0x1E903, /* C, */ 0x1E925 }, // # ADLAM CAPITAL LETTER MIIM
   { 0x1E904, /* C, */ 0x1E926 }, // # ADLAM CAPITAL LETTER BA
   { 0x1E905, /* C, */ 0x1E927 }, // # ADLAM CAPITAL LETTER SINNYIIYHE
   { 0x1E906, /* C, */ 0x1E928 }, // # ADLAM CAPITAL LETTER PE
   { 0x1E907, /* C, */ 0x1E929 }, // # ADLAM CAPITAL LETTER BHE
   { 0x1E908, /* C, */ 0x1E92A }, // # ADLAM CAPITAL LETTER RA
   { 0x1E909, /* C, */ 0x1E92B }, // # ADLAM CAPITAL LETTER E
   { 0x1E90A, /* C, */ 0x1E92C }, // # ADLAM CAPITAL LETTER FA
   { 0x1E90B, /* C, */ 0x1E92D }, // # ADLAM CAPITAL LETTER I
   { 0x1E90C, /* C, */ 0x1E92E }, // # ADLAM CAPITAL LETTER O
   { 0x1E90D, /* C, */ 0x1E92F }, // # ADLAM CAPITAL LETTER DHA
   { 0x1E90E, /* C, */ 0x1E930 }, // # ADLAM CAPITAL LETTER YHE
   { 0x1E90F, /* C, */ 0x1E931 }, // # ADLAM CAPITAL LETTER WAW
   { 0x1E910, /* C, */ 0x1E932 }, // # ADLAM CAPITAL LETTER NUN
   { 0x1E911, /* C, */ 0x1E933 }, // # ADLAM CAPITAL LETTER KAF
   { 0x1E912, /* C, */ 0x1E934 }, // # ADLAM CAPITAL LETTER YA
   { 0x1E913, /* C, */ 0x1E935 }, // # ADLAM CAPITAL LETTER U
   { 0x1E914, /* C, */ 0x1E936 }, // # ADLAM CAPITAL LETTER JIIM
   { 0x1E915, /* C, */ 0x1E937 }, // # ADLAM CAPITAL LETTER CHI
   { 0x1E916, /* C, */ 0x1E938 }, // # ADLAM CAPITAL LETTER HA
   { 0x1E917, /* C, */ 0x1E939 }, // # ADLAM CAPITAL LETTER QAAF
   { 0x1E918, /* C, */ 0x1E93A }, // # ADLAM CAPITAL LETTER GA
   { 0x1E919, /* C, */ 0x1E93B }, // # ADLAM CAPITAL LETTER NYA
   { 0x1E91A, /* C, */ 0x1E93C }, // # ADLAM CAPITAL LETTER TU
   { 0x1E91B, /* C, */ 0x1E93D }, // # ADLAM CAPITAL LETTER NHA
   { 0x1E91C, /* C, */ 0x1E93E }, // # ADLAM CAPITAL LETTER VA
   { 0x1E91D, /* C, */ 0x1E93F }, // # ADLAM CAPITAL LETTER KHA
   { 0x1E91E, /* C, */ 0x1E940 }, // # ADLAM CAPITAL LETTER GBE
   { 0x1E91F, /* C, */ 0x1E941 }, // # ADLAM CAPITAL LETTER ZAL
   { 0x1E920, /* C, */ 0x1E942 }, // # ADLAM CAPITAL LETTER KPO
   { 0x1E921, /* C, */ 0x1E943 }, // # ADLAM CAPITAL LETTER SHA
};


Candera::TextRendering::CodePoint CaseFolding::ToLower(Candera::TextRendering::CodePoint codePoint)
{
   static const FeatStd::UInt32 c_toLowerSize = sizeof(CaseFolding::mapping) / sizeof(CaseFolding::mapping[0]);

   FeatStd::UInt32 index = FeatStd::Internal::BinarySearch<Mapping, Candera::TextRendering::CodePoint, FeatStd::UInt32>(codePoint, CaseFolding::mapping, c_toLowerSize, 0);
   if (index < c_toLowerSize)
   {
      return CaseFolding::mapping[index].lower;
   }
   return codePoint;
}


FeatStd::Int CaseFolding::Mapping::Compare(Candera::TextRendering::CodePoint left, const Mapping& right)
{
   return (left == right.upper) ? 0 : ((left < right.upper) ? -1 : 1);
}


}
}


}
