/* ***************************************************************************************
* FILE:          RtStyleTypes.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtStyleTypes is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

namespace hmibase {
namespace widget {
namespace richtext {

struct TextOverflow
{
   enum Enum
   {
      Clip,       ///< Default value. The text is clipped and not accessible.
      Ellipsis,   ///< Render an ellipsis ("...") to represent the clipped text.
      String,     ///< Render the given string to represent the clipped text.
      Initial,    ///< Sets this property to its default value.
      Inherit     ///< Inherits this property from its parent element.
   };

   TextOverflow(Enum value = Clip) : m_value(value)
   {
   }

   Enum m_value;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
