/* ***************************************************************************************
* FILE:          RtStyleParameter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtStyleParameter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/TextEngine/Font.h>
#include <Candera/TextEngine/Style.h>
#include <Candera/EngineBase/Common/Color.h>
#include <hmibase/util/Macros.h>

namespace hmibase {
namespace widget {
namespace richtext {

class StyleParameterBase
{
   public:
      enum Name
      {
         FontStyle,
         TextColor,
         BackgroundColor,
         TextOverflow,

         _StartUserDefined_  // needed to add more types for e.g. unit testing
      };

      FEATSTD_TYPEDEF_SHARED_POINTER(StyleParameterBase);

      StyleParameterBase(Name type);

      virtual ~StyleParameterBase();

      Name GetName() const;

   private:
      Name m_name;

      FEATSTD_SHARED_POINTER_DECLARATION();
};


inline
StyleParameterBase::Name StyleParameterBase::GetName() const
{
   return m_name;
}


template <typename T>
class TypedStyleParameter : public StyleParameterBase
{
      typedef StyleParameterBase Base;

   public:
      TypedStyleParameter(StyleParameterBase::Name name, const T& value);
      virtual ~TypedStyleParameter();

      const T& GetValue() const;

   private:
      T m_value;
};


template <typename T>
TypedStyleParameter<T>::TypedStyleParameter(StyleParameterBase::Name name, const T& value) :
   Base(name),
   m_value(value)
{
}


template <typename T>
TypedStyleParameter<T>::~TypedStyleParameter()
{
}


template <typename T>
const T& TypedStyleParameter<T>::GetValue() const
{
   return m_value;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
