/* ***************************************************************************************
* FILE:          RtElementStyle.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtElementStyle is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/StyleProvider/RtStyleParameter.h>
#include <FeatStd/Container/Vector.h>

namespace hmibase {
namespace widget {
namespace richtext {

class ElementStyle
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(ElementStyle);

      const FeatStd::Char* GetName() const;

      StyleParameterBase::SharedPointer GetParameter(StyleParameterBase::Name name) const;

      bool AddParameter(const StyleParameterBase::SharedPointer& param);

      template <typename T>
      bool AddParameter(StyleParameterBase::Name name, const T& value);

      template <typename T>
      bool GetParameter(StyleParameterBase::Name name, T& value) const;

      void RemoveAllParameters();

   private:
      friend class ElementStyleAccessor;

      typedef FeatStd::Internal::Vector<StyleParameterBase::SharedPointer> ParameterList;

      const FeatStd::Char* m_name;
      ParameterList m_parameters;

      ElementStyle(const FeatStd::Char* name);

      FEATSTD_SHARED_POINTER_DECLARATION();
};


inline
const FeatStd::Char* ElementStyle::GetName() const
{
   return m_name;
}


template <typename T>
bool ElementStyle::AddParameter(StyleParameterBase::Name name, const T& value)
{
   TypedStyleParameter<T>* param = FEATSTD_NEW(TypedStyleParameter<T>)(name, value);
   return AddParameter(StyleParameterBase::SharedPointer(param));
}


template <typename T>
bool ElementStyle::GetParameter(StyleParameterBase::Name name, T& value) const
{
   bool found = false;

   StyleParameterBase::SharedPointer param = GetParameter(name);
   if (param != 0)
   {
      const TypedStyleParameter<T>* p = dynamic_cast<const TypedStyleParameter<T>*>(param.GetPointerToSharedInstance());
      FEATSTD_DEBUG_ASSERT(p != 0);
      if (p != 0)
      {
         value = p->GetValue();
         found = true;
      }
   }

   return found;
}


inline
void ElementStyle::RemoveAllParameters()
{
   m_parameters.Clear();
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
