/* ***************************************************************************************
* FILE:          RtElementStyle.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtElementStyle is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtElementStyle.h"

namespace hmibase {
namespace widget {
namespace richtext {

StyleParameterBase::SharedPointer ElementStyle::GetParameter(StyleParameterBase::Name name) const
{
   for (ParameterList::ConstIterator it(m_parameters.ConstBegin()); it != m_parameters.ConstEnd(); ++it)
   {
      FEATSTD_DEBUG_ASSERT((*it) != 0);
      const StyleParameterBase& param = *(*it).GetPointerToSharedInstance();
      if (param.GetName() == name)
      {
         return (*it);
      }
   }
   return StyleParameterBase::SharedPointer();
}


bool ElementStyle::AddParameter(const StyleParameterBase::SharedPointer& param)
{
   return m_parameters.Add(param);
}


ElementStyle::ElementStyle(const FeatStd::Char* name) :
   m_name(name)
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
