/* ***************************************************************************************
* FILE:          ScrollableRichTextWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RichTextHighlightWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/generated/ScrollableRichTextWidget2DBase.h>
#include <Widgets/2D/Common/FlexScrollable.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Viewport;

class ScrollableRichTextWidget2D : public ScrollableRichTextWidget2DBase,
   public FlexScrollable
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      ScrollableRichTextWidget2D();
      virtual ~ScrollableRichTextWidget2D();

      virtual void Update() override;
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;
      virtual void Init(Candera::AssetProvider* assetProvider) override;
      virtual bool OnMessage(const Courier::Message& msg) override;

      CGI_WIDGET_RTTI_DECLARATION(ScrollableRichTextWidget2D, ScrollableRichTextWidget2DBase);

      CdaWidget2DDef(ScrollableRichTextWidget2D, ScrollableRichTextWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnBeforeNodeChanged() override;
      virtual void OnNodeChanged() override;
      virtual bool OnTouch(const Candera::Camera2D& camera2D, const Candera::Vector2& point) override;
      virtual bool OnTapGesture(const hmibase::input::gesture::GestureEvent& gestureEvent) override;
      virtual bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureEvent) override;
      virtual bool OnSwipeGesture(const hmibase::input::gesture::GestureEvent& gestureEvent) override;

      // FlexScrollable overrides
      virtual void RequestImmediatePositioning(bool active) override;
      virtual bool IsScrollBarVisible() override;
      virtual FeatStd::UInt32 GetPosition() override;
      virtual FeatStd::UInt32 GetFirstFullyVisiblePosition() override;
      virtual FeatStd::UInt32 GetVisibleSize() override;
      virtual FeatStd::UInt32 GetCompleteSize() override;
      virtual Candera::Widget2D* GetWidget() override;
      virtual FeatStd::UInt32 GetMaxPosition() override;
      virtual bool IsCircular() override;
      virtual const ::Candera::ListScrollingOrientation& GetScrollingOrientation() const override;
      virtual void SetListener(FlexScrollableListener* listener) override;

   private:
      struct SwipeData
      {
         bool running;
         FeatStd::Float direction;
         FeatStd::Float velocityStart;
         FeatStd::Float acceleration;
         FeatStd::Float offsetStart;
         FeatStd::Float duration;
         FeatStd::UInt32 timeStart;

         SwipeData();
      };

      struct DragData
      {
         FeatStd::Float offsetStart;
         FeatStd::Float start;

         DragData();
      };

      Candera::Vector2 m_viewportSize;
      DragData m_drag;
      SwipeData m_swipe;
      Viewport* m_viewport;
      FlexScrollableListener* m_listener;
      FeatStd::Float m_offset;
      FeatStd::Float m_docHeight;
      FeatStd::Float m_lineHeight;

      bool OnListChangeMsg(const ListChangeMsg& listChangeMsg);
      void SetOffset(FeatStd::Float offset);
      void PageMove(FeatStd::Int pageOffset);
      void LineMove(FeatStd::Int lineOffset);
      FeatStd::Float AlignFirstLine(FeatStd::Float offset);
};


inline
Candera::Widget2D* ScrollableRichTextWidget2D::GetWidget()
{
   return this;
}


inline
bool ScrollableRichTextWidget2D::IsCircular()
{
   return false;
}


inline
const ::Candera::ListScrollingOrientation& ScrollableRichTextWidget2D::GetScrollingOrientation() const
{
   //avoids returning ref to temporary
   static const ::Candera::ListScrollingOrientation _orientation = ::Candera::Vertical;
   return _orientation;
}


inline
void ScrollableRichTextWidget2D::SetListener(FlexScrollableListener* listener)
{
   m_listener = listener;
}


inline
ScrollableRichTextWidget2D::SwipeData::SwipeData() :
   running(false),
   direction(0.0F),
   velocityStart(0.0F),
   acceleration(0.0F),
   offsetStart(0.0F),
   duration(0.0F),
   timeStart(0)
{
}


inline
ScrollableRichTextWidget2D::DragData::DragData() :
   offsetStart(0.0F),
   start(0.0F)
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
