/* ***************************************************************************************
* FILE:          RichTextWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RichTextWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/generated/RichTextWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>
#include <Widgets/2D/RichText/Engine/RtEngine.h>
#include <FeatStd/Event/EventListener.h>


namespace hmibase {
namespace widget {
namespace richtext {

class RichTextWidget2D : public RichTextWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      RichTextWidget2D();
      virtual ~RichTextWidget2D();

      virtual void Init(Candera::AssetProvider* assetProvider) override;
      virtual void Update() override;
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      CGI_WIDGET_RTTI_DECLARATION(RichTextWidget2D, RichTextWidget2DBase);

      CdaWidget2DDef(RichTextWidget2D, RichTextWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(::FeatStd::UInt32 propertyId) override;
      virtual void OnBeforeNodeChanged() override;
      virtual void OnNodeChanged() override;
      virtual void CultureChanged() override;

   private:
      typedef Candera::MemoryManagement::SharedPointer<Candera::Globalization::Culture> CulturePtr;

      Engine::SharedPointer m_richTextEngine;
      CulturePtr m_currentCulture;
      bool m_update;
      bool m_updateOffset;
      bool m_sceneComposerContext;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
