/* ***************************************************************************************
* FILE:          RichTextHighlightWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RichTextHighlightWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/generated/RichTextMarqueeWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>
#include <Widgets/2D/RichText/Engine/RtEngine.h>
#include <FeatStd/Event/EventListener.h>

namespace hmibase {
namespace widget {
namespace richtext {

class RichTextWidget2D;

class RichTextMarqueeWidget2D : public RichTextMarqueeWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      RichTextMarqueeWidget2D();
      virtual ~RichTextMarqueeWidget2D();

      virtual void Update() override;
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;
      virtual void Init(Candera::AssetProvider* assetProvider) override;

      CGI_WIDGET_RTTI_DECLARATION(RichTextMarqueeWidget2D, RichTextMarqueeWidget2DBase);

      CdaWidget2DDef(RichTextMarqueeWidget2D, RichTextMarqueeWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(::FeatStd::UInt32 propertyId) override;
      virtual void OnBeforeNodeChanged() override;
      virtual void OnNodeChanged() override;

   private:
      enum State
      {
         Disabled,
         WaitStart,
         Running,
         WaitEnd
      };

      FeatStd::Internal::Ticks m_ticks;
      State m_state;
      FeatStd::Float m_offset;
      FeatStd::Float m_visibleWidth;
      FeatStd::Float m_totalWidth;
      FeatStd::UInt32 m_loopCount;
      bool m_reverse;
      bool m_updateStartStop;

      bool AllowRestart();
      void ChangeState(State state);
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
