/* ***************************************************************************************
* FILE:          TruncationBitmapTextRenderContext.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TruncationBitmapTextRenderContext is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/EngineBase/Common/BitmapTextRenderContext.h>
#include <Candera/System/Mathematics/Rectangle.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Text;
class TruncationTextContext;


///
class TruncationBitmapTextRenderContext : public Candera::BitmapTextRenderContext
{
      typedef Candera::BitmapTextRenderContext Base;

   public:
      TruncationBitmapTextRenderContext(const Candera::TextRendering::TextRenderContext* referenceContext = 0);

      void SetColor(const Candera::Color& color);
      void SetStyle(const Candera::TextRendering::SharedStyle::SharedPointer& style);
      void SetText(const Text* text);
      void SetTruncation(bool truncate, const Candera::Rectangle& rect, const TruncationTextContext* ellipsisContext, Candera::TextRendering::BidiBaseLevel::Enum bidiLevel);
      bool TruncationMissing() const;

      virtual void Blit(FeatStd::Int16 x, FeatStd::Int16 y, const Candera::TextRendering::GlyphBitmap& glyph) override;

   private:
      enum Truncation
      {
         NoTruncation,
         LengthCheckLeftToRight,
         LengthCheckRightToLeft,
         BlitEllipsis,
         SkipRemainingGlyphs
      };

      bool PrepareBlit(FeatStd::Int16 x, FeatStd::Int16 y, const Candera::TextRendering::GlyphBitmap& glyph);

      Candera::Color m_color;
      Candera::Rectangle m_truncationRect;
      const Text* m_text;
      const TruncationTextContext* m_ellipsisContext;
      Candera::TextRendering::SharedStyle::SharedPointer m_style;
      Truncation m_truncation;
};


inline
void TruncationBitmapTextRenderContext::SetColor(const Candera::Color& color)
{
   m_color = color;
}


inline
void TruncationBitmapTextRenderContext::SetStyle(const Candera::TextRendering::SharedStyle::SharedPointer& style)
{
   m_style = style;
}


inline
void TruncationBitmapTextRenderContext::SetText(const Text* text)
{
   m_text = text;
}


inline
bool TruncationBitmapTextRenderContext::TruncationMissing() const
{
   return m_truncation == LengthCheckLeftToRight;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
