/* ***************************************************************************************
* FILE:          RtTextRenderTraverser.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtTextRenderTraverser is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/EngineBase/Common/Bitmap.h>
#include <Candera/System/Container/Map.h>
#include <Widgets/2D/RichText/DocumentModel/RtText.h>
#include <Widgets/2D/RichText/LiteHtml/TruncationTextContext.h>
#include <Widgets/2D/RichText/Renderer/RtRenderTraverserBase.h>
#include <Widgets/2D/RichText/Renderer/RtTruncationBitmapTextRenderContext.h>

namespace Candera {
class Node2D;
}


namespace hmibase {
namespace widget {
namespace richtext {

class Engine;
class Space;
class Image;

class TextRenderTraverser : public RenderTraverserBase
{
      typedef RenderTraverserBase Base;

   public:
      TextRenderTraverser(Engine& engine, const Candera::Bitmap::SharedPointer& bitmap, FeatStd::Float offsetY,
                          FeatStd::Float documentWidth);

   protected:
      virtual bool ProcessSpace(const Space& space, const Candera::Rectangle& effectiveRect) override;
      virtual bool ProcessText(const Text& text, const Candera::Rectangle& effectiveRect) override;

   private:
      struct FontId
      {
         FeatStd::UInt8 faceId;
         FeatStd::Int height;

         bool operator < (const FontId& rhs) const;
      };

      typedef Candera::Internal::Map<FontId, TruncationTextContext::SharedPointer> EllipsisContextList;

      TruncationBitmapTextRenderContext m_renderContext;
      Candera::Rectangle m_rectangle;
      FeatStd::Float m_documentWidth;

      static EllipsisContextList& GetEllipsisContextList();

      FEATSTD_MAKE_CLASS_UNCOPYABLE(TextRenderTraverser);

      bool IsWithinBoundaries(const Candera::Rectangle& effectiveRect) const;
      bool HandleTruncation(const Candera::Rectangle& effectiveRect, const Text& text, const Candera::TextRendering::SharedStyle::SharedPointer& style);
      const TruncationTextContext* GetEllipsisContext(const Candera::TextRendering::SharedStyle::SharedPointer& style) const;
};


inline
bool TextRenderTraverser::FontId::operator<(const FontId& rhs) const
{
   return (faceId < rhs.faceId) || (height < rhs.height);
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
