/* ***************************************************************************************
* FILE:          RtRenderTraverserBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtRenderTraverserBase is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtDocElementTraverser.h>


namespace hmibase {
namespace widget {
namespace richtext {

class Engine;
class Image;
class Space;
class Text;

class RenderTraverserBase : public DocElementTraverser
{
   public:
      RenderTraverserBase(Engine& engine);

      const Engine& GetEngine() const;
      Engine& GetEngine();

   protected:
      virtual bool Process(const DocElement& docElement, const Candera::Rectangle& effectiveRect) override;

      virtual void OnProcess(const DocElement& docElement, const Candera::Rectangle& effectiveRect);

      virtual bool ProcessSpace(const Space& space, const Candera::Rectangle& effectiveRect);
      virtual bool ProcessText(const Text& text, const Candera::Rectangle& effectiveRect);
      virtual bool ProcessImage(const Image& image, const Candera::Rectangle& effectiveRect);

   private:
      Engine& m_engine;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(RenderTraverserBase);

      template <typename ElementType>
      bool ProcessElement(bool(RenderTraverserBase::*Handler)(const ElementType&, const Candera::Rectangle& effectiveRect),
                          const DocElement& docElement, const Candera::Rectangle& effectiveRect, bool& terminate)
      {
         const ElementType* elem = dynamic_cast<const ElementType*>(&docElement);
         if (elem != 0)
         {
            terminate = (this->*Handler)(*elem, effectiveRect);
            return true;
         }
         return false;
      }
};


inline
const Engine& RenderTraverserBase::GetEngine() const
{
   return m_engine;
}


inline
Engine& RenderTraverserBase::GetEngine()
{
   return m_engine;
}


inline
bool RenderTraverserBase::ProcessSpace(const Space& /*space*/, const Candera::Rectangle& /*effectiveRect*/)
{
   return false;
}


inline
bool RenderTraverserBase::ProcessText(const Text& /*text*/, const Candera::Rectangle& /*effectiveRect*/)
{
   return false;
}


inline
bool RenderTraverserBase::ProcessImage(const Image& /*image*/, const Candera::Rectangle& /*effectiveRect*/)
{
   return false;
}


inline
void RenderTraverserBase::OnProcess(const DocElement& /*docElement*/, const Candera::Rectangle& /*effectiveRect*/)
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
