/* ***************************************************************************************
* FILE:          RtRenderTraverserBase.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtRenderTraverserBase is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtRenderTraverserBase.h"
#include <Widgets/2D/RichText/DocumentModel/RtImage.h>
#include <Widgets/2D/RichText/DocumentModel/RtSpace.h>


namespace hmibase {
namespace widget {
namespace richtext {


RenderTraverserBase::RenderTraverserBase(Engine& engine) :
   m_engine(engine)
{
}


bool RenderTraverserBase::Process(const DocElement& docElement, const Candera::Rectangle& effectiveRect)
{
   // if the element has an attached substitute, this has to be rendered instead
   const DocElement::SharedPointer& substituteElement = docElement.GetSubstituteElement();
   if (substituteElement != 0)
   {
      Candera::Rectangle rect(effectiveRect);
      rect.SetWidth(substituteElement->GetRect().GetWidth());
      (void)substituteElement->Process(*this, rect);
      return false;
   }

   bool terminate = false;
   // no substitute available
   (void)(
      // ProcessSpace has to handled before ProcessText because Space is derived from Text
      ProcessElement(&RenderTraverserBase::ProcessSpace, docElement, effectiveRect, terminate) ||
      ProcessElement(&RenderTraverserBase::ProcessText, docElement, effectiveRect, terminate) ||
      ProcessElement(&RenderTraverserBase::ProcessImage, docElement, effectiveRect, terminate)
   );

   OnProcess(docElement, effectiveRect);

   return terminate;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
