/* ***************************************************************************************
* FILE:          RtRenderBufferCacheItem.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtRenderBufferCacheItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/EngineBase/Common/Bitmap.h>
#include <FeatStd/Util/Rtti.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>


namespace hmibase {
namespace widget {
namespace richtext {


class RenderBufferCacheItem
{
   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(RenderBufferCacheItem);

      class LockedBitmap
      {
         public:
            LockedBitmap(const LockedBitmap& lockedBitmap);
            LockedBitmap& operator=(const LockedBitmap& othr);
            virtual ~LockedBitmap();
            const Candera::Bitmap::SharedPointer& GetBitmap();

         private:
            friend class RenderBufferCacheItem;
            LockedBitmap(Candera::Bitmap::SharedPointer& bitmap, FeatStd::Internal::CriticalSection* cs);
            Candera::Bitmap::SharedPointer& m_bitmap;
            FeatStd::Internal::CriticalSectionLocker m_locker;
      };

      static RenderBufferCacheItem::SharedPointer Create(const Candera::Bitmap::SharedPointer& bitmap);
      virtual ~RenderBufferCacheItem();

      const Candera::Bitmap::SharedPointer& GetBitmap() const;
      Candera::Bitmap::SharedPointer& GetBitmap();
      LockedBitmap GetLockedBitmap(FeatStd::Internal::CriticalSection* cs);

      void SetBitmap(Candera::Bitmap::SharedPointer& bitmap);

      bool IsUploadPending() const;
      void SetUploadPending();
      void ClearUploadPending();

   protected:
      RenderBufferCacheItem();

   private:
      // Support smart references
      FEATSTD_SHARED_POINTER_DECLARATION();
      Candera::Bitmap::SharedPointer m_bitmap;
      bool m_uploadPending;
};


inline
const Candera::Bitmap::SharedPointer& RenderBufferCacheItem::LockedBitmap::GetBitmap()
{
   return m_bitmap;
}


inline
RenderBufferCacheItem::~RenderBufferCacheItem()
{
}


inline
const Candera::Bitmap::SharedPointer& RenderBufferCacheItem::GetBitmap() const
{
   return m_bitmap;
}


inline
Candera::Bitmap::SharedPointer& RenderBufferCacheItem::GetBitmap()
{
   return m_bitmap;
}


inline
RenderBufferCacheItem::LockedBitmap RenderBufferCacheItem::GetLockedBitmap(FeatStd::Internal::CriticalSection* cs)
{
   return RenderBufferCacheItem::LockedBitmap(m_bitmap, cs);
}


inline
void RenderBufferCacheItem::SetBitmap(Candera::Bitmap::SharedPointer& bitmap)
{
   m_bitmap = bitmap;
}


inline
bool RenderBufferCacheItem::IsUploadPending() const
{
   return m_uploadPending;
}


inline
void RenderBufferCacheItem::SetUploadPending()
{
   m_uploadPending = true;
}


inline
void RenderBufferCacheItem::ClearUploadPending()
{
   m_uploadPending = false;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
