﻿/* ***************************************************************************************
* FILE:          RtRenderBufferCacheItem.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtRenderBufferCacheItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtRenderBufferCacheItem.h"

namespace hmibase {
namespace widget {
namespace richtext {

FEATSTD_RTTI_BASECLASS_DEFINITION(RenderBufferCacheItem);

RenderBufferCacheItem::LockedBitmap::LockedBitmap(Candera::Bitmap::SharedPointer& bitmap, FeatStd::Internal::CriticalSection* cs) :
   m_bitmap(bitmap),
   m_locker(cs)
{
}


RenderBufferCacheItem::LockedBitmap::LockedBitmap(const RenderBufferCacheItem::LockedBitmap& lockedBitmap) :
   m_bitmap(lockedBitmap.m_bitmap),
   m_locker(lockedBitmap.m_locker)
{
}


RenderBufferCacheItem::LockedBitmap& RenderBufferCacheItem::LockedBitmap::operator=(const RenderBufferCacheItem::LockedBitmap& othr)
{
   if (&othr != this)
   {
      m_bitmap = othr.m_bitmap;
      m_locker = othr.m_locker;
   }
   return *this;
}


RenderBufferCacheItem::LockedBitmap::~LockedBitmap()
{
   m_locker = FeatStd::Internal::CriticalSectionLocker(0);
}


RenderBufferCacheItem::SharedPointer RenderBufferCacheItem::Create(const Candera::Bitmap::SharedPointer& bitmap)
{
   RenderBufferCacheItem::SharedPointer sp = RenderBufferCacheItem::SharedPointer(FEATSTD_NEW(RenderBufferCacheItem));
   if (!sp.PointsToNull())
   {
      sp->m_bitmap = bitmap;
   }
   return sp;
}


RenderBufferCacheItem::RenderBufferCacheItem() :
   m_bitmap(),
   m_uploadPending(false)
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
