/* ***************************************************************************************
* FILE:          RtLayouter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/DefaultLayouter.h>
#else
#include <Candera/Engine2D/Layout/DefaultLayouter.h>
#endif

namespace Candera {
class Node2D;
}


namespace FeatStd {
class AsyncRequestDispatcher;
}


namespace hmibase {
namespace widget {
namespace richtext {

class Engine;
class RichTextRenderer;

class Layouter : public Candera::DefaultLayouter
{
      typedef Candera::DefaultLayouter Base;
   public:
      Layouter(RichTextRenderer& renderer);

      void SetOffset(const Candera::Vector2& offset);

      virtual Candera::Layouter* Clone() const override;
      virtual void Dispose() override;

   protected:
#if ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5))
      virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea) override;
      virtual void OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea) override;
      virtual void OnSetPosition(const Candera::AbstractNodePointer& node, const Candera::Vector2& position) override;
#define OLD_LAYOUT_INTERFACE_OVERRIDE
#else
#define OLD_LAYOUT_INTERFACE_OVERRIDE override
#endif
      virtual Candera::Vector2 OnMeasure(Candera::Node2D& node, const Candera::Vector2& clientArea) OLD_LAYOUT_INTERFACE_OVERRIDE;
      virtual void OnArrange(Candera::Node2D& node, const Candera::Rectangle& clientArea) OLD_LAYOUT_INTERFACE_OVERRIDE;
      virtual void OnSetPosition(Candera::Node2D& node, const Candera::Vector2& position) OLD_LAYOUT_INTERFACE_OVERRIDE;

   private:
      RichTextRenderer& m_renderer;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(Layouter);

      void ApplyClippingRectangle(Candera::Node2D* node, const Candera::Rectangle& clientArea);
};


inline
void Layouter::Dispose()
{
}


#if ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5))
inline
Candera::Vector2 Layouter::OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea)
{
   return OnMeasure(*(node.ToNode2D()), clientArea);
}


inline
void Layouter::OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea)
{
   OnArrange(*(node.ToNode2D()), clientArea);
}


inline
void Layouter::OnSetPosition(const Candera::AbstractNodePointer& node, const Candera::Vector2& position)
{
   OnSetPosition(*(node.ToNode2D()), position);
}


#endif

#undef OLD_LAYOUT_INTERFACE_OVERRIDE   //lint !e1960  use of '#undef' is discouraged
} // namespace richtext
} // namespace widget
} // namespace hmibase
