/* ***************************************************************************************
* FILE:          RtLayouter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtLayouter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtLayouter.h"
#include "RtRenderer.h"
#include <Widgets/2D/RichText/Engine/RtEngine.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_RICHTEXT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/RtLayouter.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace richtext {

using namespace Candera;


Layouter::Layouter(RichTextRenderer& renderer) :
   m_renderer(renderer)
{
}


Candera::Layouter* Layouter::Clone() const
{
   return 0;
}


Candera::Vector2 Layouter::OnMeasure(Node2D& node, const Candera::Vector2& clientArea)
{
   Candera::Vector2 preferredSize = m_renderer.OnMeasure(node, clientArea);
   return preferredSize;
}


void Layouter::OnArrange(Node2D& node, const Candera::Rectangle& clientArea)
{
   m_renderer.OnArrange(node, clientArea);
   Vector2 offset = m_renderer.GetEngine().GetViewport()->GetOffset();

   SetNodePosition(node, clientArea.GetPosition() + offset);

   Vector2 clippingPos = clientArea.GetPosition();
   RenderNode* renderNode = Dynamic_Cast<RenderNode*>(&node);
   if (renderNode == 0)
   {
      clippingPos -= offset;
   }

   ApplyClippingRectangle(&node, Candera::Rectangle(clippingPos, clientArea.GetSize()));
}


void Layouter::OnSetPosition(Node2D& node, const Vector2& position)
{
   Vector2 offset = m_renderer.GetEngine().GetViewport()->GetOffset();
   SetNodePosition(node, position + offset);
}


void Layouter::ApplyClippingRectangle(Node2D* node, const Candera::Rectangle& clientArea)
{
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
   if (node != 0)
   {
      Rectangle clippingRect(clientArea);
      clippingRect.SetPosition(clippingRect.GetPosition() - node->GetPosition());
      RenderNode* renderNode = Dynamic_Cast<RenderNode*>(node);
      if (renderNode != 0)
      {
         renderNode->SetClippingRect(clippingRect);
      }
      ApplyClippingRectangle(node->GetFirstChild(), clippingRect);
      ApplyClippingRectangle(node->GetNextSibling(), clippingRect);
   }
#endif
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
