/* ***************************************************************************************
* FILE:          RtDecorationRenderTraverser.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDecorationRenderTraverser is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/System/Container/Map.h>
#include <FeatStd/Async/AsyncRequest.h>
#include <Widgets/2D/RichText/DocumentModel/RtText.h>
#include <Widgets/2D/RichText/LiteHtml/TruncationTextContext.h>
#include <Widgets/2D/RichText/Renderer/RtRenderTraverserBase.h>

namespace Candera {
class Node2D;
}


namespace hmibase {
namespace widget {
namespace richtext {

class Engine;
class Space;
class Image;

class DecorationRenderTraverser : public RenderTraverserBase
{
      typedef RenderTraverserBase Base;

   public:
      DecorationRenderTraverser(Engine& engine, Candera::Node2D& node);

   protected:
      virtual void OnProcess(const DocElement& docElement, const Candera::Rectangle& effectiveRect) override;

      virtual bool ProcessSpace(const Space& space, const Candera::Rectangle& effectiveRect) override;
      virtual bool ProcessText(const Text& text, const Candera::Rectangle& effectiveRect) override;
      virtual bool ProcessImage(const Image& image, const Candera::Rectangle& effectiveRect) override;

   private:
      struct FontId
      {
         FeatStd::UInt8 faceId;
         FeatStd::Int height;

         bool operator < (const FontId& rhs) const;
      };

      class UploadRequest : public FeatStd::AsyncRequest<void>
      {
         public:
            UploadRequest(Candera::Node2D* parentNode, Candera::Node2D* node) :
               m_parentNode(parentNode),
               m_node(node)
            {
            }
            ~UploadRequest() {}

         protected:
            virtual void Execute() override;

         private:
            Candera::Node2D* m_parentNode;;
            Candera::Node2D* m_node;
      };

      Candera::Node2D& m_node;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(DecorationRenderTraverser);

      void UploadNodeAsync(Candera::Node2D* node);
      static void UploadNode(Candera::Node2D* parentNode, Candera::Node2D* node);
      void DrawHighlightBoxes(const Text::HighlightData::SharedPointer& highlightData, const Candera::Rectangle& effectiveRect);
      void DrawBackgroundBoxes(const DocElement::BoxList& boxList, const Candera::Color& color, const Candera::Rectangle& effectiveRect);
};


inline
bool DecorationRenderTraverser::FontId::operator<(const FontId& rhs) const
{
   return (faceId < rhs.faceId) || (height < rhs.height);
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
