/* ***************************************************************************************
* FILE:          LiteHtmlContext.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LiteHtmlContext is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <litehtml/include/litehtml.h>
#include <FeatStd/Container/Vector.h>
#include <Widgets/2D/RichText/ContentProvider/RtUrlResolver.h>

namespace hmibase {
namespace widget {
namespace richtext {

class LiteHtmlContext
{
   public:
      static litehtml::context* GetContext(Url styleSheetUrl);

   private:
      FEATSTD_TYPEDEF_SHARED_POINTER(LiteHtmlContext);
      typedef FeatStd::Internal::Vector<SharedPointer> List;

      struct Key
      {
         FeatStd::UInt32 m_threadId;
         FeatStd::UInt32 m_styleSheetUrlHash;

         Key(FeatStd::UInt32 threadId, Url styleSheetUrl);

         static FeatStd::Int Compare(const Key& left, const LiteHtmlContext::SharedPointer& right);
      };

      Key m_key;
      litehtml::context m_context;

      static List& GetList();

      LiteHtmlContext(FeatStd::UInt32 threadId, Url styleSheetUrl);

      FEATSTD_SHARED_POINTER_DECLARATION();
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
