/* ***************************************************************************************
* FILE:          RtParser.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtParser is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/ContentProvider/RtUrlResolver.h>
#include <Widgets/2D/RichText/DocumentModel/RtDocument.h>
#include <Candera/TextEngine/Style.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Engine;

/**
 *  Parser base class, defines the interface.
 */
class Parser
{
   public:
      /**
       *  @param engine    The rich text engine instance.
       *  @return     A smart pointer to the Document.
       */
      virtual Document::SharedPointer Parse(Engine& engine) = 0;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
