/* ***************************************************************************************
* FILE:          RtMarkups.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtMarkups is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

namespace hmibase {
namespace widget {
namespace richtext {
/**
 * Enumeration of supported mark-up languages for document creation.
 */
struct Markup
{
   enum Enum
   {
      Invalid = 0,    ///< Invalid or unsupported markup type
      // PlainText,      ///< Plain text without style and layout information
      // Markdown,       ///< Text formatted with mark-down syntax
      Html            ///< Text formatted with (limited) HTML markup
   };
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
