/* ***************************************************************************************
* FILE:          RtEngineModuleBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtEngineModuleBase is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <FeatStd/Util/Rtti.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Engine;

/**
 * The base class for functional modules of the rich text engine.
 * This class is not intended for direct use by clients (e.g. widgets).
 */
class RichTextEngineModuleBase
{
   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(RichTextEngineModuleBase);

      /** Destructor */
      virtual ~RichTextEngineModuleBase();

      /**
       * Provides the attached 'master' rich text engine.
       *
       * @return The underlying rich text engine instance or 0 if no rich text engine is attached.
       */
      virtual Engine* GetEngine();

      /**
       * Provides the attached unmodifiable 'master' rich text engine.
       *
       * @return The underlying rich text engine instance or 0 if no rich text engine is attached.
       */
      virtual const Engine* GetEngine() const;

   protected:

      ///Constructor for restricted construction.
      RichTextEngineModuleBase();

      /// Attaches the link to the 'master' rich text engine instance.
      virtual void AttachEngine(Engine* engine);

      /// Removes the link to the rich text engine instance.
      virtual void DetachEngine();

   private:
      // Support smart references
      FEATSTD_SHARED_POINTER_DECLARATION();
      friend class EngineImpl;

      /// The RT-Engine this object belongs to
      Engine* m_engine;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
