
/* ***************************************************************************************
* FILE:          RtDynamicProperties.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDynamicProperties is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "RtDynamicProperties.h"
#include <Candera/EngineBase/Common/CanderaObject.h>

namespace hmibase {
namespace widget {
namespace richtext {


void DynamicProperties::ClearMarqueeEnabled(Candera::CanderaObject* node)
{
   if (node != 0)
   {
      node->ClearValue(CdaDynamicPropertyInstance(MarqueeEnabled));
   }
}


bool DynamicProperties::IsMarqueeEnabled(const Candera::CanderaObject* node)
{
   return (node != 0) ? node->GetValue(CdaDynamicPropertyInstance(MarqueeEnabled)) : false;
}


void DynamicProperties::SetMarqueeEnabled(Candera::CanderaObject* node, bool marqueeEnabled)
{
   if (node != 0)
   {
      node->SetValue(CdaDynamicPropertyInstance(MarqueeEnabled), marqueeEnabled);
   }
}


void DynamicProperties::ClearEngine(Candera::CanderaObject* node)
{
   if (node != 0)
   {
      node->ClearValue(CdaDynamicPropertyInstance(Engine));
   }
}


Engine* DynamicProperties::GetEngine(const Candera::CanderaObject* node)
{
   return (node != 0) ? node->GetValue(CdaDynamicPropertyInstance(Engine)) : 0;
}


void DynamicProperties::SetEngine(Candera::CanderaObject* node, Engine* engine)
{
   if (node != 0)
   {
      node->SetValue(CdaDynamicPropertyInstance(Engine), engine);
   }
}


}
}


}

namespace Candera {
namespace MetaInfo {

template<> struct DataType<hmibase::widget::richtext::Engine*>
{
   static inline bool ConvertToString(hmibase::widget::richtext::Engine* const& /*ptr*/, Char* /*buf*/, UInt /*bufLen*/)
   {
      return false;
   }

   static bool ConvertFromString(hmibase::widget::richtext::Engine*& /*destination*/, const Char* /*buf*/, AssetProvider* /*provider*/ = 0)
   {
      return false;
   }

   static const Char* GetEditor()
   {
      return 0;
   }
};


}
}
