/* ***************************************************************************************
* FILE:          RtDocUnits.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDocUnits is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

namespace hmibase {
namespace widget {
namespace richtext {

/**
 * Enumeration of document units.
 */
struct DocUnits
{
   enum Enum
   {
      Invalid = 0,    ///< Invalid or unknown document unit.
      AtomicEntity,   ///< Indicates a single atomic entity, such as a single character or image.
      Word,           /**< Indicates a complete word, typically separated by document boundaries,
                                        white-spaces, or punctuation marks.  */
      Block,          ///< Indicates a full block or a complete paragraph, if the paragraphs has not blocks.
      Paragraph,      ///< Indicates a complete paragraph.
      Chapter,        ///< Indicates a complete chapter including sub-chapters.
      All             ///< Indicates the overall document.
   };
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
