/* ***************************************************************************************
* FILE:          RtEngineImpl.H
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtEngineImpl is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/System/MemoryManagement/MemoryManagement.h>

#include <Widgets/2D/RichText/Engine/RtEngine.h>
#include <Widgets/2D/RichText/Engine/Internal/RtDocAccessorImpl.h>
#include <Widgets/2D/RichText/Engine/Internal/RtCaretBasedDocManipulatorImpl.h>
#include <Widgets/2D/RichText/Engine/Internal/RtViewportImpl.h>
#include <Widgets/2D/RichText/Engine/Internal/RtHighlighterImpl.h>
#include <Widgets/2D/RichText/Renderer/RtRenderer.h>

namespace hmibase {
namespace widget {
namespace richtext {

/**
 * Implementation of Rich Text Engine interface.
 * This class is not intended being used by clients directly.
 */
class EngineImpl : public Engine
{
      FEATSTD_TYPEDEF_BASE(Engine);
   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(EngineImpl);

      EngineImpl();
      virtual ~EngineImpl();

      virtual void PrepareDocument() override;
      virtual void CreateDocument() override;
      virtual DocAccessor::SharedPointer GetDocAccessor() override;
      virtual CaretBasedDocManipulator::SharedPointer GetCaretBasedDocManipulator() override;
      virtual Viewport::SharedPointer GetViewport() override;
      virtual RichTextRenderer::SharedPointer GetRenderer() override;
      virtual Highlighter::SharedPointer GetHighlighter() override;
      virtual void SetHighlighter() override;
      virtual void Render() override;

   private:
      // The viewport instance belonging to this instance.
      ViewportImpl::SharedPointer m_viewport;
      // The rendering implementation for this engine
      RichTextRenderer::SharedPointer m_renderer;
      // The instance of the document accessor belonging to this engine.
      DocAccessorImpl::SharedPointer m_docAccessor;
      // The instance of the highlighter belonging to this engine.
      HighlighterImpl::SharedPointer m_highlighter;
      // The instance of the document manipulator for user interaction belonging to this engine.
      CaretBasedDocManipulatorImpl::SharedPointer m_caretBasedDocManipulator;

      DocAccessorImpl::SharedPointer GetDocAccessorImpl();
      CaretBasedDocManipulatorImpl::SharedPointer GetCaretBasedDocManipulatorImpl();
      ViewportImpl::SharedPointer GetViewportImpl();
};


inline
DocAccessor::SharedPointer EngineImpl::GetDocAccessor()
{
   return GetDocAccessorImpl();
}


inline
CaretBasedDocManipulator::SharedPointer EngineImpl::GetCaretBasedDocManipulator()
{
   return GetCaretBasedDocManipulatorImpl();
}


inline
Viewport::SharedPointer EngineImpl::GetViewport()
{
   return GetViewportImpl();
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
