/* ***************************************************************************************
* FILE:          RtCaretBasedDocManipulatorImpl.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtCaretBasedDocManipulatorImpl is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtCaretBasedDocManipulatorImpl.h"
#include <Widgets/2D/RichText/Engine/Internal/RtCaretImpl.h>
#include <Widgets/2D/RichText/Engine/RtEngine.h>

namespace hmibase {
namespace widget {
namespace richtext {

using FeatStd::UInt8;
using FeatStd::UInt16;
using FeatStd::Int32;
using FeatStd::UInt32;
using FeatStd::String;
using Candera::Vector2;

FEATSTD_RTTI_DEFINITION(CaretBasedDocManipulatorImpl, Base);


CaretBasedDocManipulatorImpl::SharedPointer CaretBasedDocManipulatorImpl::Create(Engine* engine)
{
   CaretBasedDocManipulatorImpl::SharedPointer sp = CaretBasedDocManipulatorImpl::SharedPointer(FEATSTD_NEW(CaretBasedDocManipulatorImpl));
   if (!sp.PointsToNull())
   {
      sp->AttachEngine(engine);
      sp->m_caret = CaretImpl::Create(engine);
   }
   return sp;
}


CaretBasedDocManipulatorImpl::CaretBasedDocManipulatorImpl() :
   Base(),
   m_caret()
{
}


CaretBasedDocManipulatorImpl::~CaretBasedDocManipulatorImpl()
{
}


Caret::SharedPointer CaretBasedDocManipulatorImpl::GetCaret()
{
   return m_caret;
}


ParagraphItem::SharedPointer CaretBasedDocManipulatorImpl::GetItemAtCaret()
{
   return ParagraphItem::SharedPointer();
}


void CaretBasedDocManipulatorImpl::PlaceCaret(Int32 /*posX*/, Int32 /*posY*/, bool /*screenCoordinates*/)
{
}


void CaretBasedDocManipulatorImpl::PlaceCaret(const Vector2& /*position*/, bool /*screenCoordinates*/)
{
}


Vector2 CaretBasedDocManipulatorImpl::GetCaretPosition(bool /*screenCoordinates*/)
{
   return  Vector2();
}


void CaretBasedDocManipulatorImpl::PlaceCaretAtBegin()
{
}


void CaretBasedDocManipulatorImpl::PlaceCaretAtEnd()
{
}


void CaretBasedDocManipulatorImpl::MoveCaret(Int32 /*count*/, DocUnits::Enum /*unit*/)
{
}


void CaretBasedDocManipulatorImpl::InsertBeforeCaret(const String& /*text*/)
{
}


void CaretBasedDocManipulatorImpl::InsertBeforeCaret(const String& /*text*/, const ElementStyle::SharedPointer /*style*/)
{
}


void CaretBasedDocManipulatorImpl::InsertAfterCaret(const String& /*text*/)
{
}


void CaretBasedDocManipulatorImpl::InsertAfterCaret(const String& /*text*/, const ElementStyle::SharedPointer /*style*/)
{
}


void CaretBasedDocManipulatorImpl::DeleteBeforeCaret(UInt32 /*count*/)
{
}


void CaretBasedDocManipulatorImpl::DeleteAfterCaret(UInt32 /*count*/)
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
