/* ***************************************************************************************
* FILE:          RtSpace.h.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtSpace.h is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtText.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Space : public Text
{
      FEATSTD_TYPEDEF_BASE(Text);

   public:
      Space();

#if defined (RICHTEXT_LOGGING_ENABLED)
      virtual void Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine = false,
                       StreamIterationData& data = StreamIterationData::defaultData) const override;
#endif
      FEATSTD_RTTI_DECLARATION();
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
