/* ***************************************************************************************
* FILE:          RtImage.hs
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtImage is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtParagraphItem.h>

namespace hmibase {
namespace widget {
namespace richtext {

/** The paragraph item representing a single image. */
class Image : public ParagraphItem
{
      FEATSTD_TYPEDEF_BASE(ParagraphItem);

   public:
      FEATSTD_RTTI_DECLARATION();

      Image();
      virtual ~Image();

      void SetName(const FeatStd::String& name);
      const FeatStd::String& GetName() const;

      virtual FeatStd::UInt16 GetItemCount() const override;

#if defined (RICHTEXT_LOGGING_ENABLED)
      virtual void Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine = false,
                       StreamIterationData& data = StreamIterationData::defaultData) const override;
#endif
   private:
      FeatStd::String m_name;
};


inline
void Image::SetName(const FeatStd::String& name)
{
   m_name = name;
}


inline
const FeatStd::String& Image::GetName() const
{
   return m_name;
}


inline
FeatStd::UInt16 Image::GetItemCount() const
{
   return 1;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
