/* ***************************************************************************************
* FILE:          RtDocument.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDocument is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtDocElement.h>
#include <Widgets/2D/RichText/DocumentModel/RtChapter.h>

namespace hmibase {
namespace widget {
namespace richtext {

/** The root element of a rich text document. */
class Document : public DocElement
{
      FEATSTD_TYPEDEF_BASE(DocElement);

   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(Document);

      Document();

      void SetBody(const Chapter::SharedPointer& body);
      Chapter::SharedPointer GetBody() const;
      virtual ParagraphItem::SharedPointer GetFirstLeafParagraphItem();
      virtual ParagraphItem::SharedPointer GetLastLeafParagraphItem();

      virtual bool Process(DocElementTraverser& traverser, const Candera::Rectangle& effectiveRect) const override;

#if defined (RICHTEXT_LOGGING_ENABLED)
      std::ostringstream m_creationStream;

      virtual void Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine = false,
                       StreamIterationData& data = StreamIterationData::defaultData) const override;
#endif
   private:
      Chapter::SharedPointer m_body;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
