/* ***************************************************************************************
* FILE:          RtChapter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtChapter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentModel/RtDocElement.h>
#include <Widgets/2D/RichText/DocumentModel/RtParagraph.h>

namespace hmibase {
namespace widget {
namespace richtext {

/** Defines hierarchical outline of the document content and can be used to generate ToC. */
class Chapter : public DocElement
{
      FEATSTD_TYPEDEF_BASE(DocElement);

   public:
      FEATSTD_RTTI_DECLARATION();
      FEATSTD_TYPEDEF_SHARED_POINTER(Chapter);

      Chapter();

      void AddTitle(const Paragraph::SharedPointer& title);
      void AddChild(const Paragraph::SharedPointer& paragraph);
      void AddChild(const Chapter::SharedPointer& chapter);

      virtual ParagraphItem::SharedPointer GetFirstLeafParagraphItem();
      virtual ParagraphItem::SharedPointer GetLastLeafParagraphItem();

      FeatStd::Int GetNestedLevel() const;

      virtual bool Process(DocElementTraverser& traverser, const Candera::Rectangle& effectiveRect) const override;

#if defined (RICHTEXT_LOGGING_ENABLED)
      void StreamChapterHierarchy(std::ostream& stream) const;

      virtual void Log(std::ostream& stream, const Candera::Rectangle& effectiveRect, bool repeatLastLine = false,
                       StreamIterationData& data = StreamIterationData::defaultData) const override;
#endif
   protected:

   private:
      typedef FeatStd::Internal::Vector<Chapter::SharedPointer> ChapterList;
      typedef FeatStd::Internal::Vector<Paragraph::SharedPointer> ParagraphList;

      Paragraph::SharedPointer m_title;
      ParagraphList m_paragraphs;
      ChapterList m_chapters;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
