/* ***************************************************************************************
* FILE:          RtFormattedDocFab.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtFormattedDocFab is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/ContentProvider/RtUrlResolver.h>
#include <Widgets/2D/RichText/DocumentModel/RtDocument.h>

namespace hmibase {
namespace widget {
namespace richtext {

class Engine;
class TextInStream;

class FormattedDocFab
{
   public:
      FEATSTD_RTTI_DECLARATION();

      FEATSTD_TYPEDEF_SHARED_POINTER(FormattedDocFab);

      virtual ~FormattedDocFab();

      virtual void Prepare(Engine& engine) = 0;
      virtual Document::SharedPointer CreateDocument(Engine& engine) = 0;

   protected:
      FormattedDocFab();

   private:
      FEATSTD_SHARED_POINTER_DECLARATION();
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
