/* ***************************************************************************************
* FILE:          RtDocumentFab.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDocumentFab is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtDocumentFab.h"
#include <Widgets/2D/RichText/LiteHtml/LiteHtmlDocFab.h>

namespace hmibase {
namespace widget {
namespace richtext {

DocumentFab& DocumentFab::GetInstance()
{
   FEATSTD_SYNCED_STATIC_OBJECT(DocumentFab, s_documentFab);
   return s_documentFab;
}


DocumentFab::DocumentFab()
{
}


void DocumentFab::Prepare(Engine& engine) const
{
   const FormattedDocFab::SharedPointer& docFab = GetDocFab(engine);
   if (docFab != 0)
   {
      docFab->Prepare(engine);
   }
}


Document::SharedPointer DocumentFab::CreateDocument(Engine& engine) const
{
   Document::SharedPointer doc;

   const FormattedDocFab::SharedPointer& docFab = GetDocFab(engine);
   if (docFab != 0)
   {
      doc = docFab->CreateDocument(engine);
   }

   return doc;
}


FormattedDocFab::SharedPointer DocumentFab::GetDocFab(Engine& engine) const
{
   FormattedDocFab::SharedPointer docFab = engine.GetDocFab();

   switch (engine.GetData().m_markup)
   {
      case Markup::Html:
      {
         LiteHtmlDocFab* liteHtmlDocFab = Candera::Dynamic_Cast<LiteHtmlDocFab*>(docFab.GetPointerToSharedInstance());
         if (liteHtmlDocFab == 0)
         {
            LiteHtmlDocFab::SharedPointer ptr(LiteHtmlDocFab::Create());
            engine.SetDocFab(ptr);
            docFab = ptr;
         }
         break;
      }

      default:
         break;
   }

   return docFab;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
