/* ***************************************************************************************
* FILE:          RtAssetUrlResolver.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtAssetUrlResolver is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>
#include <Widgets/2D/RichText/ContentProvider/RtUrlResolver.h>

namespace Candera {
class AssetProvider;
}


namespace hmibase {
namespace widget {
namespace richtext {

/** URL resolver for resources stored within asset libraries. */
class AssetUrlResolver : public UrlResolver
{
   public:
      /** @return     The AssetUrlResolver singleton instance. */
      static AssetUrlResolver& GetInstance();

      /** Stores the current asset provider that is passed to Candera::WidgetBase::Init as widget provider is diffent
          when running in Scene Composer context. */
      void SetAssetProvider(Candera::AssetProvider* assetProvider);
      Candera::AssetProvider* GetAssetProvider() const;

      virtual Candera::Bitmap::SharedPointer GetBitmap(Url baseUrl, Url resourceUrl) override;
      virtual TextInStream::SharedPointer GetTextResource(Url baseUrl, Url resourceUrl) override;
      virtual Candera::TextRendering::SharedStyle::SharedPointer GetTextStyle(Url baseUrl, Url resourceUrl) override;

   private:
      Candera::AssetProvider* m_assetProvider;

      AssetUrlResolver();
      Candera::Id GetId(Candera::AssetLib assetLib, const FeatStd::String& authority, const FeatStd::String& path) const;
};


inline
void AssetUrlResolver::SetAssetProvider(Candera::AssetProvider* assetProvider)
{
   m_assetProvider = assetProvider;
}


inline
Candera::AssetProvider* AssetUrlResolver::GetAssetProvider() const
{
   return m_assetProvider;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
