/* ***************************************************************************************
* FILE:          PanelSlideWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PanelSlideWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(CANDERA_PANELSLIDE_2D_WIDGET_H)
#define CANDERA_PANELSLIDE_2D_WIDGET_H

#include "Widgets/2D/PanelSlide/generated/PanelSlideWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class PanelSlideWidget2D : public PanelSlideWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(PanelSlideWidget2D, PanelSlideWidget2DBase);

      PanelSlideWidget2D();
      virtual ~PanelSlideWidget2D();
      virtual void InitWidget();
      virtual bool OnMessage(const Courier::Message& msg);
      void OnChanged(FeatStd::UInt32 propertyId);
      virtual bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual void Update();
      bool OnSwipeGesture(const hmibase::input::gesture::GestureEvent& gestureData);

      virtual WidgetGestureConfig getDefaultGestureConfig() const;

      // overrides from ControlTemplateCloneableWidget
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   private:
      void calStartAndEndPosition();
      void onTap();
      void onDragMove(const hmibase::input::gesture::GestureEvent& gestureData);
      void onDragLeft();
      void onDragRight();
      void onDragTop();
      void onDragBottom();
      void onDragEnd();
      void onSwipeEnd(const hmibase::input::gesture::GestureEvent& gestureData);
      void onFarwardDrag(Candera::Float);
      void onBackwardDrag(Candera::Float);
      void startAnimation(Candera::Vector2 endPoint);
      void postPanelStateMsg();
      void onPanelOpenedOrClosed();
      void onPanelRegMsg(const PanelSlideReqMsg& panelSlideReqMsg);
      void onBtnReactionMsg(const ButtonReactionMsg& buttonReactionMsg);

      void SetInvalid(bool invalid)
      {
         _invalid = invalid;
      }
      bool IsInvalid() const
      {
         return _invalid;
      }

      CdaWidget2DDef(PanelSlideWidget2D, PanelSlideWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

      Candera::Vector2 _previousTouchPos;
      Candera::Vector2 _nodeStartPosition;
      Candera::Vector2 _nodeEndPosition;
      Candera::Float _offset;
      bool _isOpened;
      bool _isTouched;
      bool _invalid;
};


#endif
