/* ***************************************************************************************
 * FILE:          PageEditWidget2D.h
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  PageEditWidget2D is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#pragma once

#include <Widgets/2D/PageEdit/generated/PageEditWidget2DBase.h>


namespace hmibase {
namespace widget {
namespace gizmo {
class GizmoWidget2D;
}


namespace pageedit {

typedef hmibase::widget::gizmo::GizmoWidget2D ItemWidget;

/*****************************************************************************/
class PageEditWidget2D : public PageEditWidget2DBase
{
   public:
      PageEditWidget2D();
      virtual ~PageEditWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(PageEditWidget2D, PageEditWidget2DBase);

      // overrides from ControlTemplateCloneableWidget
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      // overrides from DelegateWidget
      virtual hmibase::widget::WidgetController* GetDefaultController() const override;

      bool SearchItems(std::vector<ItemWidget*>& items);

      CdaWidget2DDef(PageEditWidget2D, PageEditWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


}
}


}
