/* ***************************************************************************************
* FILE:          OverlayLayouterWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OverlayLayouterWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "lint_deactivation.h"
#include "OverlayLayouterWidget2D.h"

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/OverlayLayouter.h>
#else
#include <Candera/Engine2D/Layout/OverlayLayouter.h>
#endif

#include <Widgets/2D/Common/NodeHelper.h>

#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LAYOUTER
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/OverlayLayouterWidget2D.cpp.trc.h"
#endif

CGI_WIDGET_RTTI_DEFINITION(OverlayLayouterWidget2D);


OverlayLayouterWidget2D::OverlayLayouterWidget2D() :
   _layoutNode(0),
   _originalLayouter(0)
{
}


OverlayLayouterWidget2D::~OverlayLayouterWidget2D()
{
   if ((0 != _layoutNode) && (0 != _originalLayouter))
   {
      _layoutNode->SetLayouter(_originalLayouter);
   }

   _layoutNode = 0;
   _originalLayouter = 0;
}


bool OverlayLayouterWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const OverlayLayouterWidget2D* original = CLONEABLE_WIDGET_CAST<const OverlayLayouterWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetNestedLevel(original->GetNestedLevel());

      cloned = true;
   }
   return cloned;
}


void OverlayLayouterWidget2D::Update()
{
   Candera::Node2D* node = NodeHelper::GetNestedParent(GetNode(), GetNestedLevel());
   if (_layoutNode != node)
   {
      if (0 != _layoutNode)
      {
         _layoutNode->SetLayouter(_originalLayouter);
      }
      _layoutNode = 0;
      _originalLayouter = 0;

      if ((0 != node) && (!node->IsTypeOf(Candera::Scene2D::GetTypeId())) && (node->GetLayouter() != Candera::OverlayLayouter::GetInstance()))
      {
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update  Set Layouter level=%u %s", GetNestedLevel(), HMIBASE_TO_STRING_VW(this)));
         ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "Update node=%s", HMIBASE_TO_STRING_SPN2D(GetNode())));

         _layoutNode = node;
         _originalLayouter = node->GetLayouter();
         node->SetLayouter(Candera::OverlayLayouter::GetInstance());

         InvalidateLayout();
         Invalidate();
      }
   }
}


void OverlayLayouterWidget2D::OnNodeChanged()
{
   triggerUpdate();
}
