/* ***************************************************************************************
* FILE:          OffscreenTouchProxyWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OffscreenTouchProxyWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2017 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef OFFSCREENTOUCHPROXYWIDGET2D_H
#define OFFSCREENTOUCHPROXYWIDGET2D_H

#include <Widgets/2D/OffscreenTouchProxy/generated/OffscreenTouchProxyWidget2DBase.h>

namespace Candera {
class TouchEvent;
}


namespace hmibase {
namespace view {
class ViewScene2D;
}


namespace input {
class TouchSessionStartEvent;
class TouchSessionStopEvent;
}


};

namespace Courier {
class ViewScene2D;
}


class OffscreenTouchProxyWidget2D : public OffscreenTouchProxyWidget2DBase
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(OffscreenTouchProxyWidget2D, OffscreenTouchProxyWidget2DBase);
      OffscreenTouchProxyWidget2D();
      virtual ~OffscreenTouchProxyWidget2D();

      typedef hmibase::util::ItemValRegistry<Courier::ViewId, Candera::Vector2> OffscreenTouchOffset;

   protected:
      virtual bool OnMessage(const ::Courier::Message& message) override;

   private:
      /*  CdaWidget2DDef(OffscreenTouchProxyWidget2D, OffscreenTouchProxyWidget2DBase)
            CdaProperties()
            CdaDescription("Used to map the touch coordinates for offscreen render targets")
            CdaReadableName("OffscreenTouchProxyWidget2D")
            CdaPropertiesEnd()
        CdaWidgetDefEnd()*/

      CdaWidget2DDef(OffscreenTouchProxyWidget2D, OffscreenTouchProxyWidget2DBase)
      CdaDescription("Used to map the touch coordinates for offscreen render targets")
      CdaReadableName("OffscreenTouchProxyWidget2D")
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

      bool OnTouchSessionStartEvent(const hmibase::input::TouchSessionStartEvent& msg);
      bool OnTouchSessionStopEvent(const hmibase::input::TouchSessionStopEvent& msg);
      bool OnTouchMsg(const Courier::TouchMsg& msg);

      template <typename T>
      void ForwardTouchSessionEvent(const T& msg);

      void CalcOffscreenTouchPos(FeatStd::SizeType& posX, FeatStd::SizeType& posY) const;

      hmibase::view::ViewScene2D* _viewScene;
      Candera::Vector2 _touchOffset;
};


#endif
