/* ***************************************************************************************
* FILE:          MultiSliderWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MultiSliderWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef MultiSliderWidget2D_h
#define MultiSliderWidget2D_h

#include <Widgets/2D/MultiSlider/generated/MultiSliderWidget2DBase.h>
#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>

namespace Courier {
namespace TouchHandling {
class TouchSessionStartEvent;
}


}

class MultiSliderWidget2D : public MultiSliderWidget2DBase
{
   public:
      MultiSliderWidget2D();
      virtual ~MultiSliderWidget2D() override;

      virtual void Update() override;

      CGI_WIDGET_RTTI_DECLARATION(MultiSliderWidget2D, MultiSliderWidget2DBase);

      CdaWidget2DDef(MultiSliderWidget2D, MultiSliderWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual bool OnTouchMessage(const Courier::TouchMsg& msg) override;
      virtual void OnChanged(::FeatStd::UInt32 propertyId) override;
      virtual bool OnTouch(const Candera::Camera2D& camera, const Candera::Vector2& touchedPoint) override;

   private:
      bool m_centerTouched;
      bool m_viewChanged;
      bool m_handleNodeChanged;
      FeatStd::SizeType m_touchedValueIndex;
      Candera::ArrayProperty<bool> m_valueChanged;

      Candera::Vector2 GetRelativeTouchPos(const Candera::Vector2& touchPos) const;
      FeatStd::Float CalculateValue(FeatStd::Float radius) const;
      void SetValue(FeatStd::SizeType valueIndex, FeatStd::Float value);
      void UpdateView();
      void UpdateHandle(FeatStd::SizeType valueIndex);
      void UpdateHandleNodes();
};


#endif  // MultiSliderWidget2D_h
