/* ***************************************************************************************
* FILE:          MeterWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MeterWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(METER_WIDGET_2D_H)
#define METER_WIDGET_2D_H

#include "Widgets/2D/MeterWidget/generated/MeterWidget2DBase.h"

class MeterWidget2D : public MeterWidget2DBase
{
   public:
      MeterWidget2D();
      virtual ~MeterWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(MeterWidget2D, MeterWidget2DBase);

      virtual void InitWidget(); // override
      virtual void Update(); // override
      virtual void OnChanged(::Candera::UInt32 propertyId); // override

      CdaWidget2DDef(MeterWidget2D, MeterWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      bool _requestReconfiguration;
      Candera::Float _currentIndicatorRotation;

      bool isGraphValueWithinValidRange() const;
      Candera::Float calculateCurrentRotationVal();
      void updateGraph();
};


#endif  // METER_WIDGET_2D_H
