/* ***************************************************************************************
* FILE:          MeshWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MeshWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef TRANSFORMMESH2D_WIDGET_H
#define TRANSFORMMESH2D_WIDGET_H

#include <Candera/EngineBase/Common/InterfaceAdapter.h>
#include <Widgets/2D/Mesh/generated/MeshWidget2DBase.h>
#include <Candera/Engine2D/Core/VertexGeometry2D.h>
#include <Candera/Engine2D/Core/Mesh2D.h>

namespace hmibase {
namespace widget {
namespace mesh {

class MeshWidget2D : public MeshWidget2DBase
{
   public:
      MeshWidget2D();
      virtual ~MeshWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(MeshWidget2D, MeshWidget2DBase);

      virtual void Finalize() override;
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      /**
      * Normalizes the given angle to the range between 0 (included) to 360 (excluded).
      * @param  value the angle.
      * @return the normalized angle.
      */
      static FeatStd::Float NormalizeDegree(FeatStd::Float value);

   protected:
      virtual void OnChanged(FeatStd::UInt32 propertyId) override;
      virtual void Update() override;
      virtual void OnNodeChanged() override;
      virtual void OnBeforeNodeChanged() override;

      class MeshWidget2DInterfaceAdapter : public Candera::Internal::InterfaceAdapter<MeshWidget2D>, public Candera::OverlayLayouter
      {
         protected:
            virtual Candera::Vector2 OnMeasure(const Candera::AbstractNodePointer& node, const Candera::Vector2& clientArea);
            virtual void OnArrange(const Candera::AbstractNodePointer& node, const Candera::Rectangle& clientArea);
      } m_interfaceAdapter;

   private:
      CdaWidget2DDef(MeshWidget2D, MeshWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

      Candera::VertexGeometry2D::Vertex2D m_vertices[4];
      FeatStd::UInt16 m_indices[6];
      Candera::VertexGeometry2D* m_geometry;
      Candera::Mesh2D* m_meshNode;
      bool m_setLayouter;
      bool m_updateMesh;
};


} // namespace mesh
} // namespace widget
} // namespace hmibase

#endif
