/* ***************************************************************************************
* FILE:          ListOverscrollWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListOverscrollWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ListOverscrollWidget2D_H)
#define ListOverscrollWidget2D_H

#include "Widgets/2D/ListOverscroll/generated/ListOverscrollWidget2DBase.h"
#include <Widgets/2D/List/Swiping/OverscrollFunction.h>

class ListOverscrollWidget2D : public ListOverscrollWidget2DBase, public OverscrollFunction
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ListOverscrollWidget2D, ListOverscrollWidget2DBase);

      ListOverscrollWidget2D();
      virtual ~ListOverscrollWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      virtual bool IsOnDragEnabled() override;
      virtual bool IsOnSwipeEnabled() override;
      virtual FeatStd::Float Overscroll(FeatStd::Float viewportFraction) override;
      virtual bool Relax(FeatStd::Float viewportFraction, FeatStd::Float timeMs, FeatStd::Float& relaxValue) override;

      // @WidgetBaseClass
      CdaWidget2DDef(ListOverscrollWidget2D, ListOverscrollWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

   private:
      FeatStd::Float _a;
      FeatStd::Float _x0;
      FeatStd::Float _x1;
      FeatStd::Float _v0;
      bool _ascending;

      void ComputeInitialValues(const FeatStd::Float& viewportFraction);
      virtual void OnNodeChanged() override;
};


#endif
