/* ***************************************************************************************
* FILE:          ListOverscrollWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListOverscrollWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ListOverscrollWidget2D.h"

#include <Widgets/2D/ControlTemplate/ControlTemplate.h>

CGI_WIDGET_RTTI_DEFINITION(ListOverscrollWidget2D);

using namespace Candera;

ListOverscrollWidget2D::ListOverscrollWidget2D() : _a(0.0F), _x0(0.0F), _x1(0.0F), _v0(0.0F), _ascending(false)
{
}


ListOverscrollWidget2D::~ListOverscrollWidget2D()
{
}


bool ListOverscrollWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(Base::CloneFrom(originalWidget, controlTemplateMap));

   if (cloned)
   {
      const ListOverscrollWidget2D* original = CLONEABLE_WIDGET_CAST<const ListOverscrollWidget2D*>(originalWidget);
      if (original == 0)
      {
         return false;
      }

      SetOnDrag(original->GetOnDrag());
      SetOnSwipe(original->GetOnSwipe());
      SetAttenuationFactor(original->GetAttenuationFactor());
      SetMaxRelaxingSpeed(original->GetMaxRelaxingSpeed());
   }

   return cloned;
}


bool ListOverscrollWidget2D::IsOnDragEnabled()
{
   return GetOnDrag();
}


bool ListOverscrollWidget2D::IsOnSwipeEnabled()
{
   return GetOnSwipe();
}


FeatStd::Float ListOverscrollWidget2D::Overscroll(FeatStd::Float viewportFraction)
{
   Float  factor(GetAttenuationFactor());
   if (factor < 0.0F)
   {
      factor = 0.0F;
   }
   else if (factor > 1.0F)
   {
      factor = 1.0F;
   }
   return viewportFraction * factor;
}


bool ListOverscrollWidget2D::Relax(FeatStd::Float viewportFraction, FeatStd::Float timeMs, FeatStd::Float& relaxValue)
{
   bool first(false);
   if (timeMs == 0.0F)
   {
      ComputeInitialValues(viewportFraction);
      first = true;
   }

   const Float signum((_x0 < 0) ? -1.0F : 1.0F);
   relaxValue = _x0 - _v0 * timeMs - signum * _a * timeMs * timeMs * 0.5;
   const bool currentAscending((relaxValue - _x1) > 0);
   const bool sameSign((_x1 * relaxValue) > 0);

   _x1 = relaxValue;
   return (_v0 != 0) && (((_ascending == currentAscending) && sameSign) || first);
}


void ListOverscrollWidget2D::ComputeInitialValues(const FeatStd::Float& viewportFraction)
{
   const Float maxSpeed(GetMaxRelaxingSpeed() * 0.001);
   if (maxSpeed != 0.0F && (0 != viewportFraction))
   {
      const Float signum((viewportFraction < 0) ? -1.0F : 1.0F);
      _v0 = viewportFraction * maxSpeed;
      _x0 = viewportFraction;
      _a = _v0 * _v0 * 0.5 / _x0;
      _ascending = _x0 < 0;
   }
   else
   {
      _v0 = 0.0F;
      _x0 = 0.0F;
      _a = 0.0F;
   }
}


void ListOverscrollWidget2D::OnNodeChanged()
{
   Candera::Node2D* node(GetNode());
   if (0 != node)
   {
      ControlTemplate::AddAssociatedWidget(*node, this);
   }
}
