/* ***************************************************************************************
* FILE:          ListItemAnimationMarkerWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListItemAnimationMarkerWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ListItemAnimationMarkerWidget2D_H)
#define ListItemAnimationMarkerWidget2D_H

#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/ListItemAnimationMarker/generated/ListItemAnimationMarkerWidget2DBase.h"

class ListItemAnimationMarkerWidget2D : public ListItemAnimationMarkerWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ListItemAnimationMarkerWidget2D, ListItemAnimationMarkerWidget2DBase);

      ListItemAnimationMarkerWidget2D();
      virtual ~ListItemAnimationMarkerWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      CdaWidget2DDef(ListItemAnimationMarkerWidget2D, ListItemAnimationMarkerWidget2DBase)
      CdaDescription("Controls the size property of a node.")
      CdaReadableName("ListItemAnimationMarkerWidget2D")
      CdaCategory("List")
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(Courier::UInt32 /*propertyId*/);

   private:
      AnimationType _animation;
};


#endif
