/* ***************************************************************************************
* FILE:          ListFocusControllerWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListFocusControllerWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __LIST_FOCUS_H__
#define __LIST_FOCUS_H__

#include <Widgets/2D/BaseWidget2D.h>

namespace Focus {
class FManager;
class FWidgetConfig;
class FController;
}


class ListWidget2D;

class ListFocusControllerWidget2D : public BaseWidget2D
{
   public:
      ListFocusControllerWidget2D();
      virtual ~ListFocusControllerWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(ListFocusControllerWidget2D, BaseWidget2D);

      static Focus::FController*& focusController();

      CdaWidget2DDef(ListFocusControllerWidget2D, BaseWidget2D)
      CdaDescription("")
      CdaCategory("Focus")

      CdaProperties()

      //CdaProperty(Test, bool, getTest, setTest)
      //CdaDescription("Test.")
      //CdaCategory("Focus")
      //CdaPropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void Update();
      virtual void OnNodeChanged();
      virtual void RegisterToFocusManagerImpl(Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle);

   private:
      ListWidget2D* _listWidget;
      void updateListWidget();
};


#endif
