/* ***************************************************************************************
* FILE:          SwipingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef SwipingStrategy_H
#define SwipingStrategy_H


#include <Widgets/2D/List/Swiping/Swiper.h>
#include <Widgets/2D/List/Swiping/SwipeCalculator.h>
#include <Widgets/2D/List/Swiping/SwipingBehavior.h>
#include <Widgets/2D/List/Swiping/ListPageSwipingBehaviorInfo.h>
#include <Widgets/2D/List/Content/Adders/OrientationOperator.h>
#include <FeatStd/Util/ConvenienceMacros.h>
#include <Widgets/2D/List/Swiping/OverscrollFunctionRetriever.h>
#include <Widgets/2D/List/Swiping/DefaultOverscroller.h>

class ListWidget2D;

class SwipingStrategy
{
   public:
      SwipingStrategy(OrientationOperator& orientationOperator, ItemSpeedAnimationManager& itemSpeedAnimationManager, TimeDispatcher& timeDispatcher);
      ~SwipingStrategy();

      void Init(ListWidget2D* listWidget, PositioningHandler* positioningHandler, TimeDispatcher* timeDispatcher, SwipingListener* swipingListener);

      void SetPagewiseLockOut(bool val);
      void SetFixedPageScrolling(bool val);
      void SetFixedPageScrollingOffset(FeatStd::Float val);
      void SetSwipingAcceleration(const FeatStd::Float& swipingAcceleration);
      void SetMaxSwipingDistance(FeatStd::Float val);
      void SetVisibleArea(const Candera::Vector2& val);
      void SetNormalizer(Normalizer* normalizer);
      void SetLockOutFixMovementOffset(FeatStd::Float val);
      void SetCoverflow(bool val);

      void BuildSwipingBehavior();

      bool Update(Candera::Node2D* searchNode, Candera::Node2D* contentNode, Candera::Vector2 visibleArea);
      void Reset();

      bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      bool OnSwipeGesture(const hmibase::input::gesture::GestureEvent& gestureData);

      SwipingStateChecker* GetSwipingStateChecker();
      ItemSizesContainer* GetItemSizesContainer();

      void BeginGesture(const Candera::Vector2& position);
      void StartScroll(const Candera::Vector2& pos);
      bool Scroll(const Candera::Float movementDistance, const bool forward);
      void EndScroll(const Candera::Vector2& pos);
      void StartSwipe(const Candera::Float estimatedDistance);
      bool Swipe(const Candera::Float movementDistance, const bool forward);
      void EndSwipe();

      bool IsIdleRequested() const;
      bool ShouldSnap() const;
      void SetOverscrollerListener(OverscrollerListener* listener);
   private:
      OrientationOperator& _orientationOperator;

      bool _pagewiseLockOut;
      bool _fixedPageScrolling;
      FeatStd::Float _fixedPageScrollingOffset;
      bool _coverflow;

      ListWidget2D* _listWidget;
      SwipingBehavior* _swipingBehavior;
      Swiper _swiper;
      SwipeCalculator _swipeCalculator;
      ListPageSwipingBehaviorInfo _listPageSwipingBehaviorInfo;
      ListPageSwipingBehaviorInfo _listLockoutPageSwipingBehaviorInfo;
      OverscrollFunctionRetriever _overscrollFunctionRetriever;
      DefaultOverscroller _overscroller;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(SwipingStrategy);

      bool UpdateOverscroller(Candera::Node2D* searchNode, Candera::Node2D* contentNode, Candera::Vector2 visibleArea);
};


#endif
