/* ***************************************************************************************
* FILE:          SwipingBehavior.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef SwipingBehavior_H
#define SwipingBehavior_H

#include <FeatStd/Platform/Types.h>
#include <Candera/System/Mathematics/Vector2.h>

class SwipingBehavior
{
   public:
      SwipingBehavior();

      virtual ~SwipingBehavior();

      void BeginGesture(const Candera::Vector2& position);
      void StartScroll(const Candera::Vector2& pos);
      bool Scroll(FeatStd::Float movementDistance, bool forward);
      void EndScroll(const Candera::Vector2& pos);

      void StartSwipe(const FeatStd::Float& estimatedDistance);
      bool Swipe(FeatStd::Float movementDistance, bool forward);
      void EndSwipe();

      bool IsIdleRequested() const
      {
         return _idleRequested;
      }

      bool ShouldSnap() const
      {
         return ShouldSnapImpl();
      }

   protected:
      void RequestIdle();

   private:
      bool _idleRequested;

      virtual void BeginGestureImpl(const Candera::Vector2& /*position*/) { }
      virtual void StartScrollImpl(const Candera::Vector2& /*pos*/) { }
      virtual bool ScrollImpl(FeatStd::Float /*movementDistance*/, bool /*forward*/)
      {
         return false;
      }
      virtual void EndScrollImpl(const Candera::Vector2& /*pos*/) { }

      virtual void StartSwipeImpl(const FeatStd::Float& /*estimatedDistance*/) { }
      virtual bool SwipeImpl(FeatStd::Float /*movementDistance*/, bool /*forward*/)
      {
         return false;
      }
      virtual void EndSwipeImpl() { }

      virtual bool ShouldSnapImpl() const
      {
         return true;
      }
};


#endif
