/* ***************************************************************************************
* FILE:          SwipingBehavior.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SwipingBehavior.h"


SwipingBehavior::SwipingBehavior() :
   _idleRequested(false)
{
}


SwipingBehavior::~SwipingBehavior()
{
}


void SwipingBehavior::BeginGesture(const Candera::Vector2& position)
{
   _idleRequested = false;
   BeginGestureImpl(position);
}


void SwipingBehavior::StartScroll(const Candera::Vector2& pos)
{
   StartScrollImpl(pos);
}


bool SwipingBehavior::Scroll(FeatStd::Float movementDistance, bool forward)
{
   return ScrollImpl(movementDistance, forward);
}


void SwipingBehavior::EndScroll(const Candera::Vector2& pos)
{
   EndScrollImpl(pos);
}


void SwipingBehavior::StartSwipe(const FeatStd::Float& estimatedDistance)
{
   StartSwipeImpl(estimatedDistance);
}


bool SwipingBehavior::Swipe(FeatStd::Float movementDistance, bool forward)
{
   return SwipeImpl(movementDistance, forward);
}


void SwipingBehavior::EndSwipe()
{
   EndSwipeImpl();
}


void SwipingBehavior::RequestIdle()
{
   _idleRequested = true;
}
