/* ***************************************************************************************
* FILE:          SwipingAdjuster.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwipingAdjuster is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(SwipingAdjuster_H)
#define SwipingAdjuster_H

#include <CanderaPlatform/OS/CanderaTypes.h>

class SwipingAdjuster
{
   public:
      virtual ~SwipingAdjuster() { }

      virtual FeatStd::Float AdjustInitialSwipedDistance(FeatStd::Float calculatedSwipeDistance) = 0;
      virtual FeatStd::Float AdjustSwipedDistance(FeatStd::Float calculatedSwipeDistance) = 0;
};


#endif
